/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.index.bucket.BucketIdentifier;

public class ConsistentBucketIdentifier
extends BucketIdentifier {
    private final HoodieConsistentHashingMetadata metadata;
    private final TreeMap<Integer, ConsistentHashingNode> ring;
    private final Map<String, ConsistentHashingNode> fileIdToBucket;

    public ConsistentBucketIdentifier(HoodieConsistentHashingMetadata metadata) {
        this.metadata = metadata;
        this.fileIdToBucket = new HashMap<String, ConsistentHashingNode>();
        this.ring = new TreeMap();
        this.initialize();
    }

    public Collection<ConsistentHashingNode> getNodes() {
        return this.ring.values();
    }

    public HoodieConsistentHashingMetadata getMetadata() {
        return this.metadata;
    }

    public int getNumBuckets() {
        return this.ring.size();
    }

    public ConsistentHashingNode getBucketByFileId(String fileId) {
        return this.fileIdToBucket.get(fileId);
    }

    public ConsistentHashingNode getBucket(HoodieKey hoodieKey, List<String> indexKeyFields) {
        return this.getBucket(ConsistentBucketIdentifier.getHashKeys(hoodieKey.getRecordKey(), indexKeyFields));
    }

    protected ConsistentHashingNode getBucket(List<String> hashKeys) {
        int hashValue = HashID.getXXHash32((String)String.join((CharSequence)"", hashKeys), (int)0);
        return this.getBucket(hashValue & Integer.MAX_VALUE);
    }

    protected ConsistentHashingNode getBucket(int hashValue) {
        SortedMap<Integer, ConsistentHashingNode> tailMap = this.ring.tailMap(hashValue);
        return tailMap.isEmpty() ? this.ring.firstEntry().getValue() : (ConsistentHashingNode)tailMap.get(tailMap.firstKey());
    }

    private void initialize() {
        for (ConsistentHashingNode p : this.metadata.getNodes()) {
            this.ring.put(p.getValue(), p);
            this.fileIdToBucket.put(FSUtils.createNewFileId((String)p.getFileIdPrefix(), (int)0), p);
        }
    }
}

