/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RollbackUtils {
    private static final Logger LOG = LogManager.getLogger(RollbackUtils.class);

    public static HoodieRollbackPlan getRollbackPlan(HoodieTableMetaClient metaClient, HoodieInstant rollbackInstant) throws IOException {
        HoodieInstant requested = HoodieTimeline.getRollbackRequestedInstant((HoodieInstant)rollbackInstant);
        return (HoodieRollbackPlan)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])metaClient.getActiveTimeline().readRollbackInfoAsBytes(requested).get()), HoodieRollbackPlan.class);
    }

    static Map<HoodieLogBlock.HeaderMetadataType, String> generateHeader(String instantToRollback, String rollbackInstantTime) {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(3);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, rollbackInstantTime);
        header.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, instantToRollback);
        header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_PREVIOUS_BLOCK.ordinal()));
        return header;
    }

    static HoodieRollbackStat mergeRollbackStat(HoodieRollbackStat stat1, HoodieRollbackStat stat2) {
        ValidationUtils.checkArgument((boolean)stat1.getPartitionPath().equals(stat2.getPartitionPath()));
        ArrayList successDeleteFiles = new ArrayList();
        ArrayList failedDeleteFiles = new ArrayList();
        HashMap commandBlocksCount = new HashMap();
        HashMap writtenLogFileSizeMap = new HashMap();
        Option.ofNullable((Object)stat1.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable((Object)stat2.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable((Object)stat1.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable((Object)stat2.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable((Object)stat1.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        Option.ofNullable((Object)stat2.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        return new HoodieRollbackStat(stat1.getPartitionPath(), successDeleteFiles, failedDeleteFiles, commandBlocksCount);
    }

    public static List<ListingBasedRollbackRequest> generateRollbackRequestsByListingCOW(HoodieEngineContext engineContext, String basePath) {
        return FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (String)basePath, (boolean)false, (boolean)false).stream().map(ListingBasedRollbackRequest::createRollbackRequestWithDeleteDataAndLogFilesAction).collect(Collectors.toList());
    }

    public static List<ListingBasedRollbackRequest> generateRollbackRequestsUsingFileListingMOR(HoodieInstant instantToRollback, HoodieTable table, HoodieEngineContext context) throws IOException {
        String commit = instantToRollback.getTimestamp();
        HoodieWriteConfig config = table.getConfig();
        List partitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)context, (String)table.getMetaClient().getBasePath(), (boolean)false, (boolean)false);
        if (partitions.isEmpty()) {
            return new ArrayList<ListingBasedRollbackRequest>();
        }
        int sparkPartitions = Math.max(Math.min(partitions.size(), config.getRollbackParallelism()), 1);
        context.setJobStatus(RollbackUtils.class.getSimpleName(), "Generate all rollback requests");
        return context.flatMap(partitions, (SerializableFunction & Serializable)partitionPath -> {
            HoodieActiveTimeline activeTimeline = table.getMetaClient().reloadActiveTimeline();
            ArrayList<ListingBasedRollbackRequest> partitionRollbackRequests = new ArrayList<ListingBasedRollbackRequest>();
            switch (instantToRollback.getAction()) {
                case "commit": 
                case "replacecommit": {
                    LOG.info((Object)"Rolling back commit action.");
                    partitionRollbackRequests.add(ListingBasedRollbackRequest.createRollbackRequestWithDeleteDataAndLogFilesAction(partitionPath));
                    break;
                }
                case "compaction": {
                    boolean higherDeltaCommits;
                    boolean bl = higherDeltaCommits = !activeTimeline.getDeltaCommitTimeline().filterCompletedInstants().findInstantsAfter(commit, 1).empty();
                    if (higherDeltaCommits) {
                        LOG.info((Object)"Rolling back compaction. There are higher delta commits. So only deleting data files");
                        partitionRollbackRequests.add(ListingBasedRollbackRequest.createRollbackRequestWithDeleteDataFilesOnlyAction(partitionPath));
                        break;
                    }
                    LOG.info((Object)"Rolling back compaction plan. There are NO higher delta commits. So deleting both data and log files");
                    partitionRollbackRequests.add(ListingBasedRollbackRequest.createRollbackRequestWithDeleteDataAndLogFilesAction(partitionPath));
                    break;
                }
                case "deltacommit": {
                    HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])table.getMetaClient().getCommitTimeline().getInstantDetails(instantToRollback).get()), HoodieCommitMetadata.class);
                    partitionRollbackRequests.add(ListingBasedRollbackRequest.createRollbackRequestWithDeleteDataAndLogFilesAction(partitionPath));
                    if (!commitMetadata.getPartitionToWriteStats().containsKey(partitionPath)) break;
                    partitionRollbackRequests.addAll(RollbackUtils.generateAppendRollbackBlocksAction(partitionPath, instantToRollback, commitMetadata, table));
                    break;
                }
            }
            return partitionRollbackRequests.stream();
        }, Math.min(partitions.size(), sparkPartitions)).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<ListingBasedRollbackRequest> generateAppendRollbackBlocksAction(String partitionPath, HoodieInstant rollbackInstant, HoodieCommitMetadata commitMetadata, HoodieTable table) {
        ValidationUtils.checkArgument((boolean)rollbackInstant.getAction().equals("deltacommit"));
        Map latestFileSlices = table.getSliceView().getLatestFileSlicesBeforeOrOn(partitionPath, rollbackInstant.getTimestamp(), true).collect(Collectors.toMap(FileSlice::getFileId, Function.identity()));
        return ((List)commitMetadata.getPartitionToWriteStats().get(partitionPath)).stream().filter(writeStat -> {
            boolean validForRollback;
            boolean bl = validForRollback = writeStat != null && !writeStat.getPrevCommit().equals("null") && writeStat.getPrevCommit() != null && latestFileSlices.containsKey(writeStat.getFileId());
            if (!validForRollback) {
                return false;
            }
            FileSlice latestFileSlice = (FileSlice)latestFileSlices.get(writeStat.getFileId());
            ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)latestFileSlice.getBaseInstantTime(), (BiPredicate)HoodieTimeline.LESSER_THAN_OR_EQUALS, (String)rollbackInstant.getTimestamp()), (String)"Log-file base-instant could not be less than the instant being rolled back");
            return HoodieTimeline.compareTimestamps((String)latestFileSlice.getBaseInstantTime(), (BiPredicate)HoodieTimeline.LESSER_THAN, (String)rollbackInstant.getTimestamp());
        }).map(writeStat -> {
            FileSlice latestFileSlice = (FileSlice)latestFileSlices.get(writeStat.getFileId());
            return ListingBasedRollbackRequest.createRollbackRequestWithAppendRollbackBlockAction(partitionPath, writeStat.getFileId(), latestFileSlice.getBaseInstantTime(), writeStat);
        }).collect(Collectors.toList());
    }
}

