/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.rollback.BaseRollbackHelper;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ListingBasedRollbackHelper
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(ListingBasedRollbackHelper.class);
    private final HoodieTableMetaClient metaClient;
    private final HoodieWriteConfig config;

    public ListingBasedRollbackHelper(HoodieTableMetaClient metaClient, HoodieWriteConfig config) {
        this.metaClient = metaClient;
        this.config = config;
    }

    public List<HoodieRollbackRequest> getRollbackRequestsForRollbackPlan(HoodieEngineContext context, HoodieInstant instantToRollback, List<ListingBasedRollbackRequest> rollbackRequests) {
        int sparkPartitions = Math.max(Math.min(rollbackRequests.size(), this.config.getRollbackParallelism()), 1);
        context.setJobStatus(this.getClass().getSimpleName(), "Creating Rollback Plan");
        return this.getListingBasedRollbackRequests(context, instantToRollback, rollbackRequests, sparkPartitions);
    }

    private List<HoodieRollbackRequest> getListingBasedRollbackRequests(HoodieEngineContext context, HoodieInstant instantToRollback, List<ListingBasedRollbackRequest> rollbackRequests, int numPartitions) {
        return context.map(rollbackRequests, (SerializableFunction & Serializable)rollbackRequest -> {
            switch (rollbackRequest.getType()) {
                case DELETE_DATA_FILES_ONLY: {
                    FileStatus[] filesToDeletedStatus = this.getBaseFilesToBeDeleted(this.metaClient, this.config, instantToRollback.getTimestamp(), rollbackRequest.getPartitionPath(), (FileSystem)this.metaClient.getFs());
                    List filesToBeDeleted = Arrays.stream(filesToDeletedStatus).map(fileStatus -> {
                        String fileToBeDeleted = fileStatus.getPath().toString();
                        return fileToBeDeleted.substring(fileToBeDeleted.indexOf(":") + 1);
                    }).collect(Collectors.toList());
                    return new HoodieRollbackRequest(rollbackRequest.getPartitionPath(), "", "", filesToBeDeleted, Collections.EMPTY_MAP);
                }
                case DELETE_DATA_AND_LOG_FILES: {
                    FileStatus[] filesToDeletedStatus = this.getBaseAndLogFilesToBeDeleted(instantToRollback.getTimestamp(), rollbackRequest.getPartitionPath(), (FileSystem)this.metaClient.getFs());
                    List filesToBeDeleted = Arrays.stream(filesToDeletedStatus).map(fileStatus -> {
                        String fileToBeDeleted = fileStatus.getPath().toString();
                        return fileToBeDeleted.substring(fileToBeDeleted.indexOf(":") + 1);
                    }).collect(Collectors.toList());
                    return new HoodieRollbackRequest(rollbackRequest.getPartitionPath(), "", "", filesToBeDeleted, Collections.EMPTY_MAP);
                }
                case APPEND_ROLLBACK_BLOCK: {
                    String fileId = (String)rollbackRequest.getFileId().get();
                    String latestBaseInstant = (String)rollbackRequest.getLatestBaseInstant().get();
                    HoodieWriteStat writeStat = (HoodieWriteStat)rollbackRequest.getWriteStat().get();
                    Path fullLogFilePath = FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)writeStat.getPath());
                    Map<String, Long> logFilesWithBlocksToRollback = Collections.singletonMap(fullLogFilePath.toString(), writeStat.getTotalWriteBytes());
                    return new HoodieRollbackRequest(rollbackRequest.getPartitionPath(), fileId, latestBaseInstant, Collections.EMPTY_LIST, logFilesWithBlocksToRollback);
                }
            }
            throw new IllegalStateException("Unknown Rollback action " + rollbackRequest);
        }, numPartitions);
    }

    private FileStatus[] getBaseFilesToBeDeleted(HoodieTableMetaClient metaClient, HoodieWriteConfig config, String commit, String partitionPath, FileSystem fs) throws IOException {
        LOG.info((Object)("Collecting files to be cleaned/rolledback up for path " + partitionPath + " and commit " + commit));
        String basefileExtension = metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        PathFilter filter = path -> {
            if (path.toString().contains(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime((String)path.getName());
                return commit.equals(fileCommitTime);
            }
            return false;
        };
        return fs.listStatus(FSUtils.getPartitionPath((String)config.getBasePath(), (String)partitionPath), filter);
    }

    private FileStatus[] getBaseAndLogFilesToBeDeleted(String commit, String partitionPath, FileSystem fs) throws IOException {
        String basefileExtension = this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        BaseRollbackHelper.SerializablePathFilter filter = path -> {
            if (path.toString().endsWith(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime((String)path.getName());
                return commit.equals(fileCommitTime);
            }
            if (FSUtils.isLogFile((Path)path)) {
                String fileCommitTime = FSUtils.getBaseCommitTimeFromLogPath((Path)path);
                return commit.equals(fileCommitTime);
            }
            return false;
        };
        return fs.listStatus(FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)partitionPath), (PathFilter)filter);
    }
}

