/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseMergeHelper;

public class HoodieMergeHelper<T extends HoodieRecordPayload>
extends BaseMergeHelper<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    private HoodieMergeHelper() {
    }

    public static HoodieMergeHelper newInstance() {
        return MergeHelperHolder.HOODIE_MERGE_HELPER;
    }

    @Override
    public void runMerge(HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> table, HoodieMergeHandle<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> mergeHandle) throws IOException {
        GenericDatumReader gReader;
        GenericDatumWriter gWriter;
        Schema readSchema;
        boolean externalSchemaTransformation = table.getConfig().shouldUseExternalSchemaTransformation();
        Configuration cfgForHoodieFile = new Configuration(table.getHadoopConf());
        HoodieBaseFile baseFile = mergeHandle.baseFileForMerge();
        if (externalSchemaTransformation || baseFile.getBootstrapBaseFile().isPresent()) {
            readSchema = HoodieFileReaderFactory.getFileReader((Configuration)table.getHadoopConf(), (Path)mergeHandle.getOldFilePath()).getSchema();
            gWriter = new GenericDatumWriter(readSchema);
            gReader = new GenericDatumReader(readSchema, mergeHandle.getWriterSchemaWithMetaFields());
        } else {
            gReader = null;
            gWriter = null;
            readSchema = mergeHandle.getWriterSchemaWithMetaFields();
        }
        BoundedInMemoryExecutor wrapper = null;
        HoodieFileReader reader = HoodieFileReaderFactory.getFileReader((Configuration)cfgForHoodieFile, (Path)mergeHandle.getOldFilePath());
        Option querySchemaOpt = SerDeHelper.fromJson((String)table.getConfig().getInternalSchema());
        boolean needToReWriteRecord = false;
        Map renameCols = new HashMap();
        if (querySchemaOpt.isPresent() && !baseFile.getBootstrapBaseFile().isPresent()) {
            InternalSchema querySchema = AvroSchemaEvolutionUtils.evolveSchemaFromNewAvroSchema((Schema)readSchema, (InternalSchema)((InternalSchema)querySchemaOpt.get()), (Boolean)true);
            long commitInstantTime = Long.valueOf(FSUtils.getCommitTime((String)mergeHandle.getOldFilePath().getName()));
            InternalSchema writeInternalSchema = InternalSchemaCache.searchSchemaAndCache((long)commitInstantTime, (HoodieTableMetaClient)table.getMetaClient(), (boolean)table.getConfig().getInternalSchemaCacheEnable());
            if (writeInternalSchema.isEmptySchema()) {
                throw new HoodieException(String.format("cannot find file schema for current commit %s", commitInstantTime));
            }
            List colNamesFromQuerySchema = querySchema.getAllColsFullName();
            List colNamesFromWriteSchema = writeInternalSchema.getAllColsFullName();
            List sameCols = colNamesFromWriteSchema.stream().filter(f -> colNamesFromQuerySchema.contains(f) && writeInternalSchema.findIdByName(f) == querySchema.findIdByName(f) && writeInternalSchema.findIdByName(f) != -1 && writeInternalSchema.findType(writeInternalSchema.findIdByName(f)).equals(querySchema.findType(writeInternalSchema.findIdByName(f)))).collect(Collectors.toList());
            readSchema = AvroInternalSchemaConverter.convert((InternalSchema)new InternalSchemaMerger(writeInternalSchema, querySchema, true, false, false).mergeSchema(), (String)readSchema.getName());
            Schema writeSchemaFromFile = AvroInternalSchemaConverter.convert((InternalSchema)writeInternalSchema, (String)readSchema.getName());
            boolean bl = needToReWriteRecord = sameCols.size() != colNamesFromWriteSchema.size() || SchemaCompatibility.checkReaderWriterCompatibility((Schema)readSchema, (Schema)writeSchemaFromFile).getType() == SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
            if (needToReWriteRecord) {
                renameCols = InternalSchemaUtils.collectRenameCols((InternalSchema)writeInternalSchema, (InternalSchema)querySchema);
            }
        }
        try {
            Object readerIterator = baseFile.getBootstrapBaseFile().isPresent() ? this.getMergingIterator(table, mergeHandle, baseFile, (HoodieFileReader<GenericRecord>)reader, readSchema, externalSchemaTransformation) : (needToReWriteRecord ? HoodieAvroUtils.rewriteRecordWithNewSchema((Iterator)reader.getRecordIterator(), (Schema)readSchema, renameCols) : reader.getRecordIterator(readSchema));
            ThreadLocal encoderCache = new ThreadLocal();
            ThreadLocal decoderCache = new ThreadLocal();
            wrapper = new BoundedInMemoryExecutor((long)table.getConfig().getWriteBufferLimitBytes(), (Iterator)readerIterator, (BoundedInMemoryQueueConsumer)new BaseMergeHelper.UpdateHandler(mergeHandle), record -> {
                if (!externalSchemaTransformation) {
                    return record;
                }
                return this.transformRecordBasedOnNewSchema((GenericDatumReader<GenericRecord>)gReader, (GenericDatumWriter<GenericRecord>)gWriter, encoderCache, decoderCache, (GenericRecord)record);
            }, table.getPreExecuteRunnable());
            wrapper.execute();
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (null != wrapper) {
                wrapper.shutdownNow();
                wrapper.awaitTermination();
            }
            mergeHandle.close();
        }
    }

    private static class MergeHelperHolder {
        private static final HoodieMergeHelper HOODIE_MERGE_HELPER = new HoodieMergeHelper();

        private MergeHelperHolder() {
        }
    }
}

