/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieAvroParquetConfig;
import org.apache.hudi.io.storage.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieHFileWriter;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.io.storage.HoodieOrcWriter;
import org.apache.hudi.table.HoodieTable;
import org.apache.parquet.avro.AvroSchemaConverter;

public class HoodieFileWriterFactory {
    public static <T extends HoodieRecordPayload, R extends IndexedRecord, I, K, O> HoodieFileWriter<R> getFileWriter(String instantTime, Path path, HoodieTable<T, I, K, O> hoodieTable, HoodieWriteConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        String extension = FSUtils.getFileExtension((String)path.getName());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newParquetFileWriter(instantTime, path, config, schema, hoodieTable, taskContextSupplier, config.populateMetaFields());
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newHFileFileWriter(instantTime, path, config, schema, hoodieTable.getHadoopConf(), taskContextSupplier);
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newOrcFileWriter(instantTime, path, config, schema, hoodieTable.getHadoopConf(), taskContextSupplier);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newParquetFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema, HoodieTable hoodieTable, TaskContextSupplier taskContextSupplier, boolean populateMetaFields) throws IOException {
        return HoodieFileWriterFactory.newParquetFileWriter(instantTime, path, config, schema, hoodieTable.getHadoopConf(), taskContextSupplier, populateMetaFields, populateMetaFields);
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newParquetFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema, Configuration conf, TaskContextSupplier taskContextSupplier, boolean populateMetaFields, boolean enableBloomFilter) throws IOException {
        Option filter = enableBloomFilter ? Option.of((Object)HoodieFileWriterFactory.createBloomFilter(config)) : Option.empty();
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter(conf).convert(schema), schema, filter);
        HoodieAvroParquetConfig parquetConfig = new HoodieAvroParquetConfig(writeSupport, config.getParquetCompressionCodec(), config.getParquetBlockSize(), config.getParquetPageSize(), config.getParquetMaxFileSize(), conf, config.getParquetCompressionRatio(), config.parquetDictionaryEnabled());
        return new HoodieAvroParquetWriter(path, parquetConfig, instantTime, taskContextSupplier, populateMetaFields);
    }

    static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newHFileFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema, Configuration conf, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = HoodieFileWriterFactory.createBloomFilter(config);
        HoodieHFileConfig hfileConfig = new HoodieHFileConfig(conf, config.getHFileCompressionAlgorithm(), config.getHFileBlockSize(), config.getHFileMaxFileSize(), "key", false, false, true, filter, HoodieHFileConfig.HFILE_COMPARATOR);
        return new HoodieHFileWriter(instantTime, path, hfileConfig, schema, taskContextSupplier, config.populateMetaFields());
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newOrcFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema, Configuration conf, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = HoodieFileWriterFactory.createBloomFilter(config);
        HoodieOrcConfig orcConfig = new HoodieOrcConfig(conf, config.getOrcCompressionCodec(), config.getOrcStripeSize(), config.getOrcBlockSize(), config.getOrcMaxFileSize(), filter);
        return new HoodieOrcWriter(instantTime, path, orcConfig, schema, taskContextSupplier);
    }

    private static BloomFilter createBloomFilter(HoodieWriteConfig config) {
        return BloomFilterFactory.createBloomFilter((int)config.getBloomFilterNumEntries(), (double)config.getBloomFilterFPP(), (int)config.getDynamicBloomFilterMaxNumEntries(), (String)config.getBloomFilterType());
    }
}

