/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Memory Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Controls memory usage for compaction and merges, performed internally by Hudi.")
@Immutable
public class HoodieMemoryConfig
extends HoodieConfig {
    public static final ConfigProperty<String> MAX_MEMORY_FRACTION_FOR_MERGE = ConfigProperty.key((String)"hoodie.memory.merge.fraction").defaultValue((Object)String.valueOf(0.6)).withDocumentation("This fraction is multiplied with the user memory fraction (1 - spark.memory.fraction) to get a final fraction of heap space to use during merge");
    public static final ConfigProperty<String> MAX_MEMORY_FRACTION_FOR_COMPACTION = ConfigProperty.key((String)"hoodie.memory.compaction.fraction").defaultValue((Object)String.valueOf(0.6)).withDocumentation("HoodieCompactedLogScanner reads logblocks, converts records to HoodieRecords and then merges these log blocks and records. At any point, the number of entries in a log block can be less than or equal to the number of entries in the corresponding parquet file. This can lead to OOM in the Scanner. Hence, a spillable map helps alleviate the memory pressure. Use this config to set the max allowable inMemory footprint of the spillable map");
    public static final long DEFAULT_MAX_MEMORY_FOR_SPILLABLE_MAP_IN_BYTES = 0x40000000L;
    public static final long DEFAULT_MIN_MEMORY_FOR_SPILLABLE_MAP_IN_BYTES = 0x6400000L;
    public static final ConfigProperty<Long> MAX_MEMORY_FOR_MERGE = ConfigProperty.key((String)"hoodie.memory.merge.max.size").defaultValue((Object)0x40000000L).withDocumentation("Maximum amount of memory used  in bytes for merge operations, before spilling to local storage.");
    public static final ConfigProperty<String> MAX_MEMORY_FOR_COMPACTION = ConfigProperty.key((String)"hoodie.memory.compaction.max.size").noDefaultValue().withDocumentation("Maximum amount of memory used  in bytes for compaction operations in bytes , before spilling to local storage.");
    public static final ConfigProperty<Integer> MAX_DFS_STREAM_BUFFER_SIZE = ConfigProperty.key((String)"hoodie.memory.dfs.buffer.max.size").defaultValue((Object)0x1000000).withDocumentation("Property to control the max memory in bytes for dfs input stream buffer size");
    public static final ConfigProperty<String> SPILLABLE_MAP_BASE_PATH = ConfigProperty.key((String)"hoodie.memory.spillable.map.path").defaultValue((Object)"/tmp/").withDocumentation("Default file path prefix for spillable map");
    public static final ConfigProperty<Double> WRITESTATUS_FAILURE_FRACTION = ConfigProperty.key((String)"hoodie.memory.writestatus.failure.fraction").defaultValue((Object)0.1).withDocumentation("Property to control how what fraction of the failed record, exceptions we report back to driver. Default is 10%. If set to 100%, with lot of failures, this can cause memory pressure, cause OOMs and mask actual data errors.");
    @Deprecated
    public static final String MAX_MEMORY_FRACTION_FOR_MERGE_PROP = MAX_MEMORY_FRACTION_FOR_MERGE.key();
    @Deprecated
    public static final String DEFAULT_MAX_MEMORY_FRACTION_FOR_MERGE = (String)MAX_MEMORY_FRACTION_FOR_MERGE.defaultValue();
    @Deprecated
    public static final String MAX_MEMORY_FRACTION_FOR_COMPACTION_PROP = MAX_MEMORY_FRACTION_FOR_COMPACTION.key();
    @Deprecated
    public static final String DEFAULT_MAX_MEMORY_FRACTION_FOR_COMPACTION = (String)MAX_MEMORY_FRACTION_FOR_COMPACTION.defaultValue();
    @Deprecated
    public static final String MAX_MEMORY_FOR_MERGE_PROP = MAX_MEMORY_FOR_MERGE.key();
    @Deprecated
    public static final String MAX_MEMORY_FOR_COMPACTION_PROP = MAX_MEMORY_FOR_COMPACTION.key();
    @Deprecated
    public static final String MAX_DFS_STREAM_BUFFER_SIZE_PROP = MAX_DFS_STREAM_BUFFER_SIZE.key();
    @Deprecated
    public static final int DEFAULT_MAX_DFS_STREAM_BUFFER_SIZE = (Integer)MAX_DFS_STREAM_BUFFER_SIZE.defaultValue();
    @Deprecated
    public static final String SPILLABLE_MAP_BASE_PATH_PROP = SPILLABLE_MAP_BASE_PATH.key();
    @Deprecated
    public static final String DEFAULT_SPILLABLE_MAP_BASE_PATH = (String)SPILLABLE_MAP_BASE_PATH.defaultValue();
    @Deprecated
    public static final String WRITESTATUS_FAILURE_FRACTION_PROP = WRITESTATUS_FAILURE_FRACTION.key();
    @Deprecated
    public static final double DEFAULT_WRITESTATUS_FAILURE_FRACTION = (Double)WRITESTATUS_FAILURE_FRACTION.defaultValue();

    private HoodieMemoryConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMemoryConfig memoryConfig = new HoodieMemoryConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.memoryConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.memoryConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withMaxMemoryFractionPerPartitionMerge(double maxMemoryFractionPerPartitionMerge) {
            this.memoryConfig.setValue(MAX_MEMORY_FRACTION_FOR_MERGE, String.valueOf(maxMemoryFractionPerPartitionMerge));
            return this;
        }

        public Builder withMaxMemoryMaxSize(long mergeMaxSize, long compactionMaxSize) {
            this.memoryConfig.setValue(MAX_MEMORY_FOR_MERGE, String.valueOf(mergeMaxSize));
            this.memoryConfig.setValue(MAX_MEMORY_FOR_COMPACTION, String.valueOf(compactionMaxSize));
            return this;
        }

        public Builder withMaxMemoryFractionPerCompaction(double maxMemoryFractionPerCompaction) {
            this.memoryConfig.setValue(MAX_MEMORY_FRACTION_FOR_COMPACTION, String.valueOf(maxMemoryFractionPerCompaction));
            return this;
        }

        public Builder withMaxDFSStreamBufferSize(int maxStreamBufferSize) {
            this.memoryConfig.setValue(MAX_DFS_STREAM_BUFFER_SIZE, String.valueOf(maxStreamBufferSize));
            return this;
        }

        public Builder withWriteStatusFailureFraction(double failureFraction) {
            this.memoryConfig.setValue(WRITESTATUS_FAILURE_FRACTION, String.valueOf(failureFraction));
            return this;
        }

        public HoodieMemoryConfig build() {
            this.memoryConfig.setDefaults(HoodieMemoryConfig.class.getName());
            return this.memoryConfig;
        }
    }
}

