/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MergeOnReadRollbackActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseRollbackActionExecutor<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(MergeOnReadRollbackActionExecutor.class);

    public MergeOnReadRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipLocking) {
        super(context, config, table, instantTime, commitInstant, deleteInstants, skipLocking);
    }

    public MergeOnReadRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipTimelinePublish, boolean useMarkerBasedStrategy, boolean skipLocking) {
        super(context, config, table, instantTime, commitInstant, deleteInstants, skipTimelinePublish, useMarkerBasedStrategy, skipLocking);
    }

    @Override
    protected List<HoodieRollbackStat> executeRollback(HoodieRollbackPlan hoodieRollbackPlan) {
        HoodieTimer rollbackTimer = new HoodieTimer();
        rollbackTimer.startTimer();
        LOG.info((Object)("Rolling back instant " + this.instantToRollback));
        if (this.instantToRollback.isCompleted()) {
            LOG.info((Object)("Un-publishing instant " + this.instantToRollback + ", deleteInstants=" + this.deleteInstants));
            this.resolvedInstant = this.table.getActiveTimeline().revertToInflight(this.instantToRollback);
            this.table.getMetaClient().reloadActiveTimeline();
        }
        List<HoodieRollbackStat> allRollbackStats = new ArrayList<HoodieRollbackStat>();
        if (!this.resolvedInstant.isRequested()) {
            LOG.info((Object)("Unpublished " + this.resolvedInstant));
            allRollbackStats = this.executeRollback(this.instantToRollback, hoodieRollbackPlan);
        }
        this.dropBootstrapIndexIfNeeded(this.resolvedInstant);
        LOG.info((Object)("Time(in ms) taken to finish rollback " + rollbackTimer.endTimer()));
        return allRollbackStats;
    }
}

