/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.metrics.datadog.DatadogReporter;

public class DatadogMetricsReporter
extends MetricsReporter {
    private final DatadogReporter reporter;
    private final int reportPeriodSeconds;

    public DatadogMetricsReporter(HoodieWriteConfig config, MetricRegistry registry) {
        this.reportPeriodSeconds = config.getDatadogReportPeriodSeconds();
        DatadogHttpClient.ApiSite apiSite = config.getDatadogApiSite();
        String apiKey = config.getDatadogApiKey();
        ValidationUtils.checkState((!StringUtils.isNullOrEmpty((String)apiKey) ? 1 : 0) != 0, (String)"Datadog cannot be initialized: API key is null or empty.");
        boolean skipValidation = config.getDatadogApiKeySkipValidation();
        int timeoutSeconds = config.getDatadogApiTimeoutSeconds();
        String prefix = config.getDatadogMetricPrefix();
        ValidationUtils.checkState((!StringUtils.isNullOrEmpty((String)prefix) ? 1 : 0) != 0, (String)"Datadog cannot be initialized: Metric prefix is null or empty.");
        Option host = Option.ofNullable((Object)config.getDatadogMetricHost());
        List<String> tagList = config.getDatadogMetricTags();
        Option tags = tagList.isEmpty() ? Option.empty() : Option.of(tagList);
        this.reporter = new DatadogReporter(registry, new DatadogHttpClient(apiSite, apiKey, skipValidation, timeoutSeconds), prefix, (Option<String>)host, (Option<List<String>>)tags, MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS);
    }

    @Override
    public void start() {
        this.reporter.start(this.reportPeriodSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    @Override
    public Closeable getReporter() {
        return this.reporter;
    }

    @Override
    public void stop() {
        this.reporter.stop();
    }
}

