/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieWriteConfig {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPropertyLoading(boolean withAlternative) throws IOException {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath("/tmp");
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put(HoodieCompactionConfig.CLEANER_COMMITS_RETAINED.key(), "1");
        params.put(HoodieCompactionConfig.MAX_COMMITS_TO_KEEP.key(), "5");
        params.put(HoodieCompactionConfig.MIN_COMMITS_TO_KEEP.key(), "2");
        if (withAlternative) {
            params.put("hoodie.avro.schema.externalTransformation", "true");
        } else {
            params.put("hoodie.avro.schema.external.transformation", "true");
        }
        ByteArrayOutputStream outStream = this.saveParamsIntoOutputStream(params);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
        try {
            builder = builder.fromInputStream((InputStream)inputStream);
        }
        finally {
            outStream.close();
            inputStream.close();
        }
        HoodieWriteConfig config = builder.build();
        Assertions.assertEquals((int)5, (int)config.getMaxCommitsToKeep());
        Assertions.assertEquals((int)2, (int)config.getMinCommitsToKeep());
        Assertions.assertTrue((boolean)config.shouldUseExternalSchemaTransformation());
    }

    @Test
    public void testDefaultIndexAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getIndexType, this.constructConfigMap(EngineType.SPARK, HoodieIndex.IndexType.BLOOM, EngineType.FLINK, HoodieIndex.IndexType.INMEMORY, EngineType.JAVA, HoodieIndex.IndexType.INMEMORY));
    }

    @Test
    public void testDefaultClusteringPlanStrategyClassAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getClusteringPlanStrategyClass, this.constructConfigMap(EngineType.SPARK, "org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy", EngineType.FLINK, "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy", EngineType.JAVA, "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy"));
    }

    @Test
    public void testDefaultClusteringExecutionStrategyClassAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getClusteringExecutionStrategyClass, this.constructConfigMap(EngineType.SPARK, "org.apache.hudi.client.clustering.run.strategy.SparkSortAndSizeExecutionStrategy", EngineType.FLINK, "org.apache.hudi.client.clustering.run.strategy.JavaSortAndSizeExecutionStrategy", EngineType.JAVA, "org.apache.hudi.client.clustering.run.strategy.JavaSortAndSizeExecutionStrategy"));
    }

    @Test
    public void testDefaultMarkersTypeAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getMarkersType, this.constructConfigMap(EngineType.SPARK, MarkerType.TIMELINE_SERVER_BASED, EngineType.FLINK, MarkerType.DIRECT, EngineType.JAVA, MarkerType.DIRECT));
    }

    private ByteArrayOutputStream saveParamsIntoOutputStream(Map<String, String> params) throws IOException {
        Properties properties = new Properties();
        properties.putAll(params);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        properties.store(outStream, "Saved on " + new Date(System.currentTimeMillis()));
        return outStream;
    }

    private void testEngineSpecificConfig(Function<HoodieWriteConfig, Object> getConfigFunc, Map<EngineType, Object> expectedConfigMap) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").build();
        Assertions.assertEquals((Object)expectedConfigMap.get(EngineType.SPARK), (Object)getConfigFunc.apply(writeConfig));
        for (EngineType engineType : expectedConfigMap.keySet()) {
            writeConfig = HoodieWriteConfig.newBuilder().withEngineType(engineType).withPath("/tmp").build();
            Assertions.assertEquals((Object)expectedConfigMap.get(engineType), (Object)getConfigFunc.apply(writeConfig));
        }
    }

    private Map<EngineType, Object> constructConfigMap(EngineType k1, Object v1, EngineType k2, Object v2, EngineType k3, Object v3) {
        HashMap<EngineType, Object> mapping = new HashMap<EngineType, Object>();
        mapping.put(k1, v1);
        mapping.put(k2, v2);
        mapping.put(k3, v3);
        return mapping;
    }
}

