/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInProcessLockProvider {
    private static final Logger LOG = LogManager.getLogger(TestInProcessLockProvider.class);
    private final Configuration hadoopConfiguration = new Configuration();
    private final LockConfiguration lockConfiguration = new LockConfiguration((Properties)new TypedProperties());

    @Test
    public void testLockAcquisition() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testLockReAcquisitionBySameThread() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testLockReAcquisitionByDifferentThread() {
        final InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        final AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Thread writer2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
                Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
                writer2Completed.set(true);
            }
        });
        writer2.start();
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
        try {
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer2Completed.get());
    }

    @Test
    public void testTryLockAcquisition() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testTryLockAcquisitionWithTimeout() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock(1L, TimeUnit.MILLISECONDS));
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testTryLockReAcquisitionBySameThread() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider.tryLock(1L, TimeUnit.MILLISECONDS));
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testTryLockReAcquisitionByDifferentThread() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
        Thread writer2 = new Thread(() -> {
            Assertions.assertFalse((boolean)inProcessLockProvider.tryLock(100L, TimeUnit.MILLISECONDS));
            writer2Completed.set(true);
        });
        writer2.start();
        try {
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer2Completed.get());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
    }

    @Test
    public void testTryLockAcquisitionBeforeTimeOutFromTwoThreads() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        int threadCount = 3;
        long awaitMaxTimeoutMs = 2000L;
        CountDownLatch latch = new CountDownLatch(3);
        AtomicBoolean writer1Completed = new AtomicBoolean(false);
        AtomicBoolean writer2Completed = new AtomicBoolean(false);
        Thread writer1 = new Thread(() -> {
            Assertions.assertTrue((boolean)inProcessLockProvider.tryLock());
            latch.countDown();
            try {
                latch.await(2000L, TimeUnit.MILLISECONDS);
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
            writer1Completed.set(true);
        });
        writer1.start();
        Thread writer2 = new Thread(() -> {
            latch.countDown();
            Assertions.assertTrue((boolean)inProcessLockProvider.tryLock(2000L, TimeUnit.MILLISECONDS));
            Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
            writer2Completed.set(true);
        });
        writer2.start();
        latch.countDown();
        try {
            writer1.join();
            writer2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)writer1Completed.get());
        Assertions.assertTrue((boolean)writer2Completed.get());
    }

    @Test
    public void testLockReleaseByClose() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.close());
    }

    @Test
    public void testRedundantUnlock() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.lock());
        Assertions.assertDoesNotThrow(() -> inProcessLockProvider.unlock());
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider.unlock());
    }

    @Test
    public void testUnlockWithoutLock() {
        InProcessLockProvider inProcessLockProvider = new InProcessLockProvider(this.lockConfiguration, this.hadoopConfiguration);
        Assertions.assertThrows(HoodieLockException.class, () -> inProcessLockProvider.unlock());
    }
}

