/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTestCommitGenerator {
    public static final String BASE_FILE_WRITE_TOKEN = "1-0-1";
    public static final String LOG_FILE_WRITE_TOKEN = "0-0-0";
    private static final Logger LOG = LogManager.getLogger(HoodieTestCommitGenerator.class);

    public static void initCommitInfoForRepairTests(Map<String, List<Pair<String, String>>> baseFileInfo, Map<String, List<Pair<String, String>>> logFileInfo) {
        baseFileInfo.clear();
        logFileInfo.clear();
        baseFileInfo.put("000", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/01", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/02", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/03", (Object)UUID.randomUUID().toString())}));
        baseFileInfo.put("001", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/04", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/05", (Object)UUID.randomUUID().toString())}));
        baseFileInfo.put("002", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/06", (Object)UUID.randomUUID().toString())}));
        logFileInfo.put("001", CollectionUtils.createImmutableList((Object[])new Pair[]{new ImmutablePair((Object)"2022/01/03", (Object)UUID.randomUUID().toString()), new ImmutablePair((Object)"2022/01/06", (Object)UUID.randomUUID().toString())}));
    }

    public static void setupTimelineInFS(String basePath, Map<String, List<Pair<String, String>>> baseFileInfo, Map<String, List<Pair<String, String>>> logFileInfo, Map<String, Map<String, List<Pair<String, String>>>> instantInfoMap) throws IOException {
        instantInfoMap.clear();
        for (String instantTime : baseFileInfo.keySet()) {
            HashMap<String, List<Pair<String, String>>> partitionPathToFileIdAndNameMap = new HashMap<String, List<Pair<String, String>>>();
            ((List)baseFileInfo.getOrDefault(instantTime, new ArrayList())).forEach(e -> {
                List fileInfoList = partitionPathToFileIdAndNameMap.computeIfAbsent((String)e.getKey(), k -> new ArrayList());
                String fileId = (String)e.getValue();
                fileInfoList.add(new ImmutablePair((Object)fileId, (Object)HoodieTestCommitGenerator.getBaseFilename(instantTime, fileId)));
            });
            ((List)logFileInfo.getOrDefault(instantTime, new ArrayList())).forEach(e -> {
                List fileInfoList = partitionPathToFileIdAndNameMap.computeIfAbsent((String)e.getKey(), k -> new ArrayList());
                String fileId = (String)e.getValue();
                fileInfoList.add(new ImmutablePair((Object)fileId, (Object)HoodieTestCommitGenerator.getLogFilename(instantTime, fileId)));
            });
            HoodieTestCommitGenerator.createCommitAndDataFiles(basePath, instantTime, partitionPathToFileIdAndNameMap);
            instantInfoMap.put(instantTime, partitionPathToFileIdAndNameMap);
        }
    }

    public static String getBaseFilename(String instantTime, String fileId) {
        return FSUtils.makeDataFileName((String)instantTime, (String)BASE_FILE_WRITE_TOKEN, (String)fileId);
    }

    public static String getLogFilename(String instantTime, String fileId) {
        return FSUtils.makeLogFileName((String)fileId, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantTime, (int)1, (String)LOG_FILE_WRITE_TOKEN);
    }

    public static void createCommitAndDataFiles(String basePath, String instantTime, Map<String, List<Pair<String, String>>> partitionPathToFileIdAndNameMap) throws IOException {
        String commitFilename = HoodieTimeline.makeCommitFileName((String)instantTime);
        HoodieCommitMetadata commitMetadata = HoodieTestCommitGenerator.generateCommitMetadata(partitionPathToFileIdAndNameMap, Collections.emptyMap());
        String content = commitMetadata.toJsonString();
        HoodieTestCommitGenerator.createCommitFileWithMetadata(basePath, new Configuration(), commitFilename, content);
        for (String partitionPath : partitionPathToFileIdAndNameMap.keySet()) {
            partitionPathToFileIdAndNameMap.get(partitionPath).forEach(fileInfo -> {
                String filename = (String)fileInfo.getValue();
                try {
                    HoodieTestCommitGenerator.createDataFile(basePath, new Configuration(), partitionPath, filename);
                }
                catch (IOException e) {
                    LOG.error((Object)String.format("Failed to create data file: %s/%s/%s", basePath, partitionPath, filename));
                }
            });
        }
    }

    public static HoodieCommitMetadata generateCommitMetadata(Map<String, List<Pair<String, String>>> partitionPathToFileIdAndNameMap, Map<String, String> extraMetadata) {
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        for (Map.Entry<String, String> entry : extraMetadata.entrySet()) {
            metadata.addMetadata(entry.getKey(), entry.getValue());
        }
        partitionPathToFileIdAndNameMap.forEach((partitionPath, fileInfoList) -> fileInfoList.forEach(fileInfo -> {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partitionPath);
            writeStat.setPath(new Path(partitionPath, (String)fileInfo.getValue()).toString());
            writeStat.setFileId((String)fileInfo.getKey());
            writeStat.setTotalWriteBytes(10000L);
            writeStat.setPrevCommit("000");
            writeStat.setNumWrites(10L);
            writeStat.setNumUpdateWrites(15L);
            writeStat.setTotalLogBlocks(2L);
            writeStat.setTotalLogRecords(100L);
            metadata.addWriteStat(partitionPath, writeStat);
        }));
        return metadata;
    }

    public static void createCommitFileWithMetadata(String basePath, Configuration configuration, String filename, String content) throws IOException {
        Path commitFilePath = new Path(basePath + "/" + ".hoodie" + "/" + filename);
        try (FSDataOutputStream os = FSUtils.getFs((String)basePath, (Configuration)configuration).create(commitFilePath, true);){
            os.writeBytes(new String(content.getBytes(StandardCharsets.UTF_8)));
        }
    }

    public static void createDataFile(String basePath, Configuration configuration, String partitionPath, String filename) throws IOException {
        Path filePath;
        Path parent;
        FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)configuration);
        if (!fs.exists(parent = (filePath = new Path(new Path(basePath, partitionPath), filename)).getParent())) {
            fs.mkdirs(parent);
        }
        if (!fs.exists(filePath)) {
            fs.create(filePath);
        }
    }
}

