/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.table.HoodieTable;

public class CompactHelpers<T extends HoodieRecordPayload, I, K, O> {
    private static final CompactHelpers SINGLETON_INSTANCE = new CompactHelpers();

    private CompactHelpers() {
    }

    public static CompactHelpers getInstance() {
        return SINGLETON_INSTANCE;
    }

    public HoodieCommitMetadata createCompactionMetadata(HoodieTable table, String compactionInstantTime, HoodieData<WriteStatus> writeStatuses, String schema) throws IOException {
        byte[] planBytes = (byte[])table.getActiveTimeline().readCompactionPlanAsBytes(HoodieTimeline.getCompactionRequestedInstant((String)compactionInstantTime)).get();
        HoodieCompactionPlan compactionPlan = TimelineMetadataUtils.deserializeCompactionPlan((byte[])planBytes);
        List updateStatusMap = writeStatuses.map(WriteStatus::getStat).collectAsList();
        HoodieCommitMetadata metadata = new HoodieCommitMetadata(true);
        for (HoodieWriteStat stat : updateStatusMap) {
            metadata.addWriteStat(stat.getPartitionPath(), stat);
        }
        metadata.addMetadata("schema", schema);
        if (compactionPlan.getExtraMetadata() != null) {
            compactionPlan.getExtraMetadata().forEach((arg_0, arg_1) -> ((HoodieCommitMetadata)metadata).addMetadata(arg_0, arg_1));
        }
        return metadata;
    }

    public void completeInflightCompaction(HoodieTable table, String compactionCommitTime, HoodieCommitMetadata commitMetadata) {
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        try {
            activeTimeline.transitionCompactionInflightToComplete(new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionCommitTime), Option.of((Object)commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new HoodieCompactionException("Failed to commit " + table.getMetaClient().getBasePath() + " at time " + compactionCommitTime, e);
        }
    }
}

