/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LockManager
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(LockManager.class);
    private final HoodieWriteConfig writeConfig;
    private final LockConfiguration lockConfiguration;
    private final SerializableConfiguration hadoopConf;
    private volatile LockProvider lockProvider;
    private final AtomicReference<Option<HoodieInstant>> latestCompletedWriteInstant = new AtomicReference<Option>(Option.empty());

    public LockManager(HoodieWriteConfig writeConfig, FileSystem fs) {
        this.writeConfig = writeConfig;
        this.hadoopConf = new SerializableConfiguration(fs.getConf());
        this.lockConfiguration = new LockConfiguration((Properties)writeConfig.getProps());
    }

    public void lock() {
        if (this.writeConfig.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            LockProvider lockProvider = this.getLockProvider();
            int retryCount = 0;
            boolean acquired = false;
            int retries = this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.client.num_retries");
            long waitTimeInMs = this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.client.wait_time_ms_between_retry");
            while (retryCount <= retries) {
                try {
                    acquired = lockProvider.tryLock(this.writeConfig.getLockAcquireWaitTimeoutInMs().longValue(), TimeUnit.MILLISECONDS);
                    if (acquired) break;
                    LOG.info((Object)"Retrying to acquire lock...");
                    Thread.sleep(waitTimeInMs);
                    ++retryCount;
                }
                catch (InterruptedException | HoodieLockException e) {
                    if (retryCount < retries) continue;
                    throw new HoodieLockException("Unable to acquire lock, lock object ", e);
                }
            }
            if (!acquired) {
                throw new HoodieLockException("Unable to acquire lock, lock object " + lockProvider.getLock());
            }
        }
    }

    public void unlock() {
        if (this.writeConfig.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            this.getLockProvider().unlock();
        }
    }

    public synchronized LockProvider getLockProvider() {
        if (this.lockProvider == null) {
            LOG.info((Object)("LockProvider " + this.writeConfig.getLockProviderClass()));
            this.lockProvider = (LockProvider)ReflectionUtils.loadClass((String)this.writeConfig.getLockProviderClass(), (Object[])new Object[]{this.lockConfiguration, this.hadoopConf.get()});
        }
        return this.lockProvider;
    }

    public void setLatestCompletedWriteInstant(Option<HoodieInstant> instant) {
        this.latestCompletedWriteInstant.set(instant);
    }

    public void compareAndSetLatestCompletedWriteInstant(Option<HoodieInstant> expected, Option<HoodieInstant> newValue) {
        this.latestCompletedWriteInstant.compareAndSet(expected, newValue);
    }

    public AtomicReference<Option<HoodieInstant>> getLatestCompletedWriteInstant() {
        return this.latestCompletedWriteInstant;
    }

    public void resetLatestCompletedWriteInstant() {
        this.latestCompletedWriteInstant.set((Option<HoodieInstant>)Option.empty());
    }

    @Override
    public void close() {
        this.closeQuietly();
    }

    private void closeQuietly() {
        try {
            if (this.lockProvider != null) {
                this.lockProvider.close();
                LOG.info((Object)"Released connection created for acquiring lock");
                this.lockProvider = null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to close and release connection created for acquiring lock", (Throwable)e);
        }
    }
}

