/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.Gauge;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestPushGateWayReporter {
    @Mock
    HoodieWriteConfig config;

    @AfterEach
    void shutdownMetrics() {
        Metrics.shutdown();
    }

    @Test
    public void testRegisterGauge() {
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getTableName()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.PROMETHEUS_PUSHGATEWAY);
        Mockito.when((Object)this.config.getPushGatewayHost()).thenReturn((Object)"localhost");
        Mockito.when((Object)this.config.getPushGatewayPort()).thenReturn((Object)9091);
        Mockito.when((Object)this.config.getPushGatewayReportPeriodSeconds()).thenReturn((Object)30);
        Mockito.when((Object)this.config.getPushGatewayDeleteOnShutdown()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getPushGatewayJobName()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getPushGatewayRandomJobNameSuffix()).thenReturn((Object)false);
        Assertions.assertDoesNotThrow(() -> new HoodieMetrics(this.config));
        Metrics.registerGauge((String)"pushGateWayReporter_metric", (long)123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get("pushGateWayReporter_metric")).getValue().toString());
    }
}

