/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDatadogHttpClient {
    @Mock
    AppenderSkeleton appender;
    @Captor
    ArgumentCaptor<LoggingEvent> logCaptor;
    @Mock
    CloseableHttpClient httpClient;
    @Mock
    CloseableHttpResponse httpResponse;
    @Mock
    StatusLine statusLine;

    @AfterEach
    void resetMocks() {
        Mockito.reset((Object[])new Object[]{this.appender, this.httpClient, this.httpResponse, this.statusLine});
    }

    private void mockResponse(int statusCode) {
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)this.statusLine);
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)this.httpResponse);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void validateApiKeyShouldThrowExceptionWhenRequestFailed() throws IOException {
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenThrow(IOException.class);
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> new DatadogHttpClient(DatadogHttpClient.ApiSite.EU, "foo", false, this.httpClient));
        Assertions.assertEquals((Object)"Failed to connect to Datadog to validate API key.", (Object)t.getMessage());
    }

    @Test
    public void validateApiKeyShouldThrowExceptionWhenResponseNotSuccessful() {
        this.mockResponse(500);
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> new DatadogHttpClient(DatadogHttpClient.ApiSite.EU, "foo", false, this.httpClient));
        Assertions.assertEquals((Object)"API key is invalid.", (Object)t.getMessage());
    }

    @Test
    public void sendPayloadShouldLogWhenRequestFailed() throws IOException {
        Logger.getRootLogger().addAppender((Appender)this.appender);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenThrow(IOException.class);
        DatadogHttpClient ddClient = new DatadogHttpClient(DatadogHttpClient.ApiSite.US, "foo", true, this.httpClient);
        ddClient.send("{}");
        ((AppenderSkeleton)Mockito.verify((Object)this.appender)).doAppend((LoggingEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send to Datadog.", (Object)((LoggingEvent)this.logCaptor.getValue()).getRenderedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LoggingEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void sendPayloadShouldLogUnsuccessfulSending() {
        Logger.getRootLogger().addAppender((Appender)this.appender);
        this.mockResponse(401);
        Mockito.when((Object)this.httpResponse.toString()).thenReturn((Object)"unauthorized");
        DatadogHttpClient ddClient = new DatadogHttpClient(DatadogHttpClient.ApiSite.US, "foo", true, this.httpClient);
        ddClient.send("{}");
        ((AppenderSkeleton)Mockito.verify((Object)this.appender)).doAppend((LoggingEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send to Datadog. Response was unauthorized", (Object)((LoggingEvent)this.logCaptor.getValue()).getRenderedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LoggingEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void sendPayloadShouldLogSuccessfulSending() {
        Logger.getRootLogger().addAppender((Appender)this.appender);
        this.mockResponse(202);
        DatadogHttpClient ddClient = new DatadogHttpClient(DatadogHttpClient.ApiSite.US, "foo", true, this.httpClient);
        ddClient.send("{}");
        ((AppenderSkeleton)Mockito.verify((Object)this.appender)).doAppend((LoggingEvent)this.logCaptor.capture());
        Assertions.assertTrue((boolean)((LoggingEvent)this.logCaptor.getValue()).getRenderedMessage().startsWith("Sent metrics data"));
        Assertions.assertEquals((Object)Level.DEBUG, (Object)((LoggingEvent)this.logCaptor.getValue()).getLevel());
    }

    public static List<Arguments> getApiSiteAndDomain() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{"US", "com"}), Arguments.of((Object[])new Object[]{"EU", "eu"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getApiSiteAndDomain"})
    public void testApiSiteReturnCorrectDomain(String apiSite, String domain) {
        Assertions.assertEquals((Object)domain, (Object)DatadogHttpClient.ApiSite.valueOf((String)apiSite).getDomain());
    }
}

