/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestHoodieMetrics {
    @Mock
    HoodieWriteConfig config;
    HoodieMetrics metrics;

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getTableName()).thenReturn((Object)"raw_table");
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.INMEMORY);
        this.metrics = new HoodieMetrics(this.config);
    }

    @AfterEach
    void shutdownMetrics() {
        Metrics.shutdown();
    }

    @Test
    public void testRegisterGauge() {
        Metrics.registerGauge((String)"metric1", (long)123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get("metric1")).getValue().toString());
    }

    @Test
    public void testTimerCtx() throws InterruptedException {
        Random rand = new Random();
        Timer.Context timer = this.metrics.getIndexCtx();
        Thread.sleep(5L);
        this.metrics.updateIndexMetrics("some_action", this.metrics.getDurationInMs(timer.stop()));
        String metricName = this.metrics.getMetricsName("index", "some_action.duration");
        long msec = (Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        timer = this.metrics.getRollbackCtx();
        Thread.sleep(5L);
        long numFilesDeleted = 1 + rand.nextInt();
        this.metrics.updateRollbackMetrics(this.metrics.getDurationInMs(timer.stop()), numFilesDeleted);
        metricName = this.metrics.getMetricsName("rollback", "duration");
        msec = (Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        metricName = this.metrics.getMetricsName("rollback", "numFilesDeleted");
        Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricName)).getValue()), (long)numFilesDeleted);
        timer = this.metrics.getRollbackCtx();
        Thread.sleep(5L);
        numFilesDeleted = 1 + rand.nextInt();
        this.metrics.updateCleanMetrics(this.metrics.getDurationInMs(timer.stop()), (int)numFilesDeleted);
        metricName = this.metrics.getMetricsName("clean", "duration");
        msec = (Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        metricName = this.metrics.getMetricsName("clean", "numFilesDeleted");
        Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricName)).getValue()), (long)numFilesDeleted);
        timer = this.metrics.getFinalizeCtx();
        Thread.sleep(5L);
        long numFilesFinalized = 1 + rand.nextInt();
        this.metrics.updateFinalizeWriteMetrics(this.metrics.getDurationInMs(timer.stop()), (long)((int)numFilesFinalized));
        metricName = this.metrics.getMetricsName("finalize", "duration");
        msec = (Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        metricName = this.metrics.getMetricsName("finalize", "numFilesFinalized");
        Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricName)).getValue()), (long)numFilesFinalized);
        Stream.of("commit", "deltacommit", "compaction").forEach(action -> {
            Timer.Context commitTimer = action.equals("commit") ? this.metrics.getCommitCtx() : (action.equals("deltacommit") ? this.metrics.getDeltaCommitCtx() : this.metrics.getCompactionCtx());
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long randomValue = 1 + rand.nextInt();
            HoodieCommitMetadata metadata = (HoodieCommitMetadata)Mockito.mock(HoodieCommitMetadata.class);
            Mockito.when((Object)metadata.fetchTotalPartitionsWritten()).thenReturn((Object)(randomValue + 1L));
            Mockito.when((Object)metadata.fetchTotalFilesInsert()).thenReturn((Object)(randomValue + 2L));
            Mockito.when((Object)metadata.fetchTotalFilesUpdated()).thenReturn((Object)(randomValue + 3L));
            Mockito.when((Object)metadata.fetchTotalRecordsWritten()).thenReturn((Object)(randomValue + 4L));
            Mockito.when((Object)metadata.fetchTotalUpdateRecordsWritten()).thenReturn((Object)(randomValue + 5L));
            Mockito.when((Object)metadata.fetchTotalInsertRecordsWritten()).thenReturn((Object)(randomValue + 6L));
            Mockito.when((Object)metadata.fetchTotalBytesWritten()).thenReturn((Object)(randomValue + 7L));
            Mockito.when((Object)metadata.getTotalScanTime()).thenReturn((Object)(randomValue + 8L));
            Mockito.when((Object)metadata.getTotalCreateTime()).thenReturn((Object)(randomValue + 9L));
            Mockito.when((Object)metadata.getTotalUpsertTime()).thenReturn((Object)(randomValue + 10L));
            Mockito.when((Object)metadata.getTotalCompactedRecordsUpdated()).thenReturn((Object)(randomValue + 11L));
            Mockito.when((Object)metadata.getTotalLogFilesCompacted()).thenReturn((Object)(randomValue + 12L));
            Mockito.when((Object)metadata.getTotalLogFilesSize()).thenReturn((Object)(randomValue + 13L));
            Mockito.when((Object)metadata.getMinAndMaxEventTime()).thenReturn((Object)Pair.of((Object)Option.empty(), (Object)Option.empty()));
            this.metrics.updateCommitMetrics(randomValue + 14L, commitTimer.stop(), metadata, action);
            String metricname = this.metrics.getMetricsName(action, "duration");
            long duration = (Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue();
            Assertions.assertTrue((duration > 0L ? 1 : 0) != 0);
            metricname = this.metrics.getMetricsName(action, "totalPartitionsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalPartitionsWritten());
            metricname = this.metrics.getMetricsName(action, "totalFilesInsert");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalFilesInsert());
            metricname = this.metrics.getMetricsName(action, "totalFilesUpdate");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalFilesUpdated());
            metricname = this.metrics.getMetricsName(action, "totalRecordsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalRecordsWritten());
            metricname = this.metrics.getMetricsName(action, "totalUpdateRecordsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalUpdateRecordsWritten());
            metricname = this.metrics.getMetricsName(action, "totalInsertRecordsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalInsertRecordsWritten());
            metricname = this.metrics.getMetricsName(action, "totalBytesWritten");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalBytesWritten());
            metricname = this.metrics.getMetricsName(action, "commitTime");
            Assertions.assertEquals((long)((Long)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue()), (long)(randomValue + 14L));
            metricname = this.metrics.getMetricsName(action, "totalScanTime");
            Assertions.assertEquals((Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalScanTime());
            metricname = this.metrics.getMetricsName(action, "totalCreateTime");
            Assertions.assertEquals((Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalCreateTime());
            metricname = this.metrics.getMetricsName(action, "totalUpsertTime");
            Assertions.assertEquals((Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalUpsertTime());
            metricname = this.metrics.getMetricsName(action, "totalCompactedRecordsUpdated");
            Assertions.assertEquals((Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalCompactedRecordsUpdated());
            metricname = this.metrics.getMetricsName(action, "totalLogFilesCompacted");
            Assertions.assertEquals((Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalLogFilesCompacted());
            metricname = this.metrics.getMetricsName(action, "totalLogFilesSize");
            Assertions.assertEquals((Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalLogFilesSize());
        });
    }
}

