/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import java.io.IOException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieAvroKeyGeneratorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieAvroKeyGeneratorFactory {
    @Test
    public void testKeyGeneratorFactory() throws IOException {
        TypedProperties props = this.getCommonProps();
        props.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.SIMPLE.name());
        KeyGenerator keyGenerator = HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        Assertions.assertEquals((Object)SimpleAvroKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
        props = this.getCommonProps();
        props.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)SimpleAvroKeyGenerator.class.getName());
        KeyGenerator keyGenerator2 = HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        Assertions.assertEquals((Object)SimpleAvroKeyGenerator.class.getName(), (Object)keyGenerator2.getClass().getName());
        props.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.CUSTOM.name());
        KeyGenerator keyGenerator3 = HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        Assertions.assertEquals((Object)SimpleAvroKeyGenerator.class.getName(), (Object)keyGenerator3.getClass().getName());
        TypedProperties props2 = this.getCommonProps();
        props2.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)TestHoodieAvroKeyGeneratorFactory.class.getName());
        Assertions.assertThrows(IOException.class, () -> HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)props2));
        TypedProperties props3 = this.getCommonProps();
        props3.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)"wrong_type");
        Assertions.assertThrows(HoodieKeyGeneratorException.class, () -> HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)props3));
    }

    private TypedProperties getCommonProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }
}

