/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieAvroKeyGeneratorFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestCreateAvroKeyGeneratorByTypeWithFactory {
    private TypedProperties props;

    private static Stream<Arguments> configParams() {
        String[] types = new String[]{KeyGeneratorType.SIMPLE.name(), KeyGeneratorType.TIMESTAMP.name(), KeyGeneratorType.COMPLEX.name(), KeyGeneratorType.CUSTOM.name(), KeyGeneratorType.NON_PARTITION.name(), KeyGeneratorType.GLOBAL_DELETE.name()};
        return Stream.of(types).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @BeforeEach
    public void init() {
        this.props = new TypedProperties();
        this.props.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        this.props.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        this.props.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        this.props.put((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type", (Object)"DATE_STRING");
        this.props.put((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat", (Object)"yyyy-MM-dd");
        this.props.put((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat", (Object)"yyyyMMdd");
    }

    @AfterEach
    public void teardown() {
        this.props = null;
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testKeyGeneratorTypes(String keyGenType) throws IOException {
        this.props.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)keyGenType);
        KeyGeneratorType keyType = KeyGeneratorType.valueOf((String)keyGenType);
        KeyGenerator keyGenerator = HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)this.props);
        switch (keyType) {
            case SIMPLE: {
                Assertions.assertEquals((Object)SimpleAvroKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case COMPLEX: {
                Assertions.assertEquals((Object)ComplexAvroKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case TIMESTAMP: {
                Assertions.assertEquals((Object)TimestampBasedAvroKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case CUSTOM: {
                Assertions.assertEquals((Object)CustomAvroKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case NON_PARTITION: {
                Assertions.assertEquals((Object)NonpartitionedAvroKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
            case GLOBAL_DELETE: {
                Assertions.assertEquals((Object)GlobalAvroDeleteKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
                return;
            }
        }
        throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGenType);
    }
}

