/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.io.storage.HoodieOrcWriter;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHoodieOrcReaderWriter {
    private final Path filePath = new Path(System.getProperty("java.io.tmpdir") + "/f1_1-0-1_000.orc");

    @BeforeEach
    @AfterEach
    public void clearTempFile() {
        File file = new File(this.filePath.toString());
        if (file.exists()) {
            file.delete();
        }
    }

    private HoodieOrcWriter createOrcWriter(Schema avroSchema) throws Exception {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-5, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        Configuration conf = new Configuration();
        int orcStripSize = Integer.parseInt((String)HoodieStorageConfig.ORC_STRIPE_SIZE.defaultValue());
        int orcBlockSize = Integer.parseInt((String)HoodieStorageConfig.ORC_BLOCK_SIZE.defaultValue());
        int maxFileSize = Integer.parseInt((String)HoodieStorageConfig.ORC_FILE_MAX_SIZE.defaultValue());
        HoodieOrcConfig config = new HoodieOrcConfig(conf, CompressionKind.ZLIB, orcStripSize, orcBlockSize, (long)maxFileSize, filter);
        TaskContextSupplier mockTaskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        String instantTime = "000";
        return new HoodieOrcWriter(instantTime, this.filePath, config, avroSchema, mockTaskContextSupplier);
    }

    @Test
    public void testWriteReadMetadata() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchema.avsc");
        HoodieOrcWriter writer = this.createOrcWriter(avroSchema);
        for (int i = 0; i < 3; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("_row_key", (Object)("key" + i));
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            writer.writeAvro("key" + i, (IndexedRecord)record);
        }
        writer.close();
        Configuration conf = new Configuration();
        Reader orcReader = OrcFile.createReader((Path)this.filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        Assertions.assertEquals((int)4, (int)orcReader.getMetadataKeys().size());
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("hoodie_min_record_key"));
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("hoodie_max_record_key"));
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("org.apache.hudi.bloomfilter"));
        Assertions.assertTrue((boolean)orcReader.getMetadataKeys().contains("orc.avro.schema"));
        Assertions.assertEquals((Object)CompressionKind.ZLIB.name(), (Object)orcReader.getCompressionKind().toString());
        HoodieFileReader hoodieReader = HoodieFileReaderFactory.getFileReader((Configuration)conf, (Path)this.filePath);
        BloomFilter filter = hoodieReader.readBloomFilter();
        for (int i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)filter.mightContain("key" + i));
        }
        Assertions.assertFalse((boolean)filter.mightContain("non-existent-key"));
        Assertions.assertEquals((long)3L, (long)hoodieReader.getTotalRecords());
        String[] minMaxRecordKeys = hoodieReader.readMinMaxRecordKeys();
        Assertions.assertEquals((int)2, (int)minMaxRecordKeys.length);
        Assertions.assertEquals((Object)"key0", (Object)minMaxRecordKeys[0]);
        Assertions.assertEquals((Object)"key2", (Object)minMaxRecordKeys[1]);
    }

    @Test
    public void testWriteReadPrimitiveRecord() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchema.avsc");
        HoodieOrcWriter writer = this.createOrcWriter(avroSchema);
        for (int i = 0; i < 3; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("_row_key", (Object)("key" + i));
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            writer.writeAvro("key" + i, (IndexedRecord)record);
        }
        writer.close();
        Configuration conf = new Configuration();
        Reader orcReader = OrcFile.createReader((Path)this.filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        Assertions.assertEquals((Object)"struct<_row_key:string,time:string,number:int>", (Object)orcReader.getSchema().toString());
        Assertions.assertEquals((long)3L, (long)orcReader.getNumberOfRows());
        HoodieFileReader hoodieReader = HoodieFileReaderFactory.getFileReader((Configuration)conf, (Path)this.filePath);
        Iterator iter = hoodieReader.getRecordIterator();
        int index = 0;
        while (iter.hasNext()) {
            GenericRecord record = (GenericRecord)iter.next();
            Assertions.assertEquals((Object)("key" + index), (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            ++index;
        }
    }

    @Test
    public void testWriteReadComplexRecord() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchemaWithUDT.avsc");
        Schema udtSchema = (Schema)avroSchema.getField("driver").schema().getTypes().get(1);
        HoodieOrcWriter writer = this.createOrcWriter(avroSchema);
        for (int i = 0; i < 3; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("_row_key", (Object)("key" + i));
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            GenericData.Record innerRecord = new GenericData.Record(udtSchema);
            innerRecord.put("driver_name", (Object)("driver" + i));
            innerRecord.put("list", Collections.singletonList(i));
            innerRecord.put("map", Collections.singletonMap("key" + i, "value" + i));
            record.put("driver", (Object)innerRecord);
            writer.writeAvro("key" + i, (IndexedRecord)record);
        }
        writer.close();
        Configuration conf = new Configuration();
        Reader reader = OrcFile.createReader((Path)this.filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        Assertions.assertEquals((Object)"struct<_row_key:string,time:string,number:int,driver:struct<driver_name:string,list:array<int>,map:map<string,string>>>", (Object)reader.getSchema().toString());
        Assertions.assertEquals((long)3L, (long)reader.getNumberOfRows());
        HoodieFileReader hoodieReader = HoodieFileReaderFactory.getFileReader((Configuration)conf, (Path)this.filePath);
        Iterator iter = hoodieReader.getRecordIterator();
        int index = 0;
        while (iter.hasNext()) {
            GenericRecord record = (GenericRecord)iter.next();
            Assertions.assertEquals((Object)("key" + index), (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            GenericRecord innerRecord = (GenericRecord)record.get("driver");
            Assertions.assertEquals((Object)("driver" + index), (Object)innerRecord.get("driver_name").toString());
            Assertions.assertEquals((int)1, (int)((List)innerRecord.get("list")).size());
            Assertions.assertEquals((Object)index, ((List)innerRecord.get("list")).get(0));
            Assertions.assertEquals((Object)("value" + index), (Object)((Map)innerRecord.get("map")).get("key" + index).toString());
            ++index;
        }
    }

    @Test
    public void testWriteReadWithEvolvedSchema() throws Exception {
        GenericRecord record;
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchema.avsc");
        HoodieOrcWriter writer = this.createOrcWriter(avroSchema);
        for (int i = 0; i < 3; ++i) {
            GenericData.Record record2 = new GenericData.Record(avroSchema);
            record2.put("_row_key", (Object)("key" + i));
            record2.put("time", (Object)Integer.toString(i));
            record2.put("number", (Object)i);
            writer.writeAvro("key" + i, (IndexedRecord)record2);
        }
        writer.close();
        Configuration conf = new Configuration();
        HoodieFileReader hoodieReader = HoodieFileReaderFactory.getFileReader((Configuration)conf, (Path)this.filePath);
        Schema evolvedSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleEvolvedSchema.avsc");
        Iterator iter = hoodieReader.getRecordIterator(evolvedSchema);
        int index = 0;
        while (iter.hasNext()) {
            record = (GenericRecord)iter.next();
            Assertions.assertEquals((Object)("key" + index), (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            Assertions.assertNull((Object)record.get("added_field"));
            ++index;
        }
        evolvedSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleEvolvedSchemaChangeOrder.avsc");
        iter = hoodieReader.getRecordIterator(evolvedSchema);
        index = 0;
        while (iter.hasNext()) {
            record = (GenericRecord)iter.next();
            Assertions.assertEquals((Object)("key" + index), (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            Assertions.assertNull((Object)record.get("added_field"));
            ++index;
        }
        evolvedSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleEvolvedSchemaColumnRequire.avsc");
        iter = hoodieReader.getRecordIterator(evolvedSchema);
        index = 0;
        while (iter.hasNext()) {
            record = (GenericRecord)iter.next();
            Assertions.assertEquals((Object)("key" + index), (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            Assertions.assertNull((Object)record.get("added_field"));
            ++index;
        }
        evolvedSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleEvolvedSchemaColumnType.avsc");
        iter = hoodieReader.getRecordIterator(evolvedSchema);
        index = 0;
        while (iter.hasNext()) {
            record = (GenericRecord)iter.next();
            Assertions.assertEquals((Object)("key" + index), (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("number").toString());
            Assertions.assertNull((Object)record.get("added_field"));
            ++index;
        }
        evolvedSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleEvolvedSchemaDeleteColumn.avsc");
        iter = hoodieReader.getRecordIterator(evolvedSchema);
        index = 0;
        while (iter.hasNext()) {
            record = (GenericRecord)iter.next();
            Assertions.assertEquals((Object)("key" + index), (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertNull((Object)record.get("number"));
            Assertions.assertNull((Object)record.get("added_field"));
            ++index;
        }
    }
}

