/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.cli.commands.SparkEnvCommand;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.launcher.SparkLauncher;

public class SparkUtil {
    public static final String DEFAULT_SPARK_MASTER = "yarn";

    public static SparkLauncher initLauncher(String propertiesFile) throws URISyntaxException {
        File libDirectory;
        String currentJar = new File(SparkUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
        Map<String, String> env = SparkEnvCommand.env;
        SparkLauncher sparkLauncher = new SparkLauncher(env).setAppResource(currentJar).setMainClass(SparkMain.class.getName());
        if (!StringUtils.isNullOrEmpty((String)propertiesFile)) {
            sparkLauncher.setPropertiesFile(propertiesFile);
        }
        if ((libDirectory = new File(new File(currentJar).getParent(), "lib")).exists()) {
            Arrays.stream(libDirectory.list()).forEach(library -> sparkLauncher.addJar(new File(libDirectory, (String)library).getAbsolutePath()));
        } else {
            String sparkBundleJarPath = System.getenv("SPARK_BUNDLE_JAR");
            if (!StringUtils.isNullOrEmpty((String)sparkBundleJarPath)) {
                sparkLauncher.addJar(sparkBundleJarPath);
            }
        }
        return sparkLauncher;
    }

    public static SparkConf getDefaultConf(String appName, Option<String> sparkMaster) {
        Properties properties = System.getProperties();
        SparkConf sparkConf = new SparkConf().setAppName(appName);
        String sparkMasterNode = DEFAULT_SPARK_MASTER;
        if (properties.getProperty("SPARK_MASTER") != null) {
            sparkMasterNode = properties.getProperty("SPARK_MASTER");
        }
        if (sparkMaster.isPresent() && !((String)sparkMaster.get()).trim().isEmpty()) {
            sparkMasterNode = (String)sparkMaster.orElse((Object)sparkMasterNode);
        }
        sparkConf.setMaster(sparkMasterNode);
        sparkConf.set("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.eventLog.overwrite", "true");
        sparkConf.set("spark.eventLog.enabled", "false");
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar");
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        return sparkConf;
    }

    public static JavaSparkContext initJavaSparkContext(String name) {
        return SparkUtil.initJavaSparkContext(name, (Option<String>)Option.empty(), (Option<String>)Option.empty());
    }

    public static JavaSparkContext initJavaSparkContext(String name, Option<String> master, Option<String> executorMemory) {
        SparkConf sparkConf = SparkUtil.getDefaultConf(name, master);
        if (executorMemory.isPresent()) {
            sparkConf.set("spark.executor.memory", (String)executorMemory.get());
        }
        return SparkUtil.initJavaSparkContext(sparkConf);
    }

    public static JavaSparkContext initJavaSparkContext(SparkConf sparkConf) {
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        jsc.hadoopConfiguration().setBoolean("parquet.enable.summary-metadata", false);
        HadoopFSUtils.prepareHadoopConf((Configuration)jsc.hadoopConfiguration());
        return jsc;
    }
}

