/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparator;
import org.apache.hudi.common.table.timeline.InstantFileNameParser;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class TimelineCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCommand.class);
    private static final SimpleDateFormat DATE_FORMAT_DEFAULT = new SimpleDateFormat("MM-dd HH:mm");
    private static final SimpleDateFormat DATE_FORMAT_SECONDS = new SimpleDateFormat("MM-dd HH:mm:ss");

    @ShellMethod(key={"timeline show active"}, value="List all instants in active timeline")
    public String showActive(@ShellOption(value={"--limit"}, help="Limit #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--with-metadata-table"}, help="Show metadata table timeline together with data table", defaultValue="false") boolean withMetadataTable, @ShellOption(value={"--show-rollback-info"}, help="Show instant to rollback for rollbacks", defaultValue="false") boolean showRollbackInfo, @ShellOption(value={"--show-time-seconds"}, help="Show seconds in instant file modification time", defaultValue="false") boolean showTimeSeconds) {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        try {
            if (withMetadataTable) {
                HoodieTableMetaClient mtMetaClient = this.getMetadataTableMetaClient(metaClient);
                return this.printTimelineInfoWithMetadataTable((HoodieTimeline)metaClient.getActiveTimeline(), (HoodieTimeline)mtMetaClient.getActiveTimeline(), this.getInstantInfoFromTimeline(metaClient, metaClient.getStorage(), metaClient.getTimelinePath()), this.getInstantInfoFromTimeline(mtMetaClient, mtMetaClient.getStorage(), mtMetaClient.getTimelinePath()), limit, sortByField, descending, headerOnly, true, showTimeSeconds, showRollbackInfo);
            }
            return this.printTimelineInfo((HoodieTimeline)metaClient.getActiveTimeline(), this.getInstantInfoFromTimeline(metaClient, metaClient.getStorage(), metaClient.getTimelinePath()), limit, sortByField, descending, headerOnly, true, showTimeSeconds, showRollbackInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @ShellMethod(key={"timeline show incomplete"}, value="List all incomplete instants in active timeline")
    public String showIncomplete(@ShellOption(value={"--limit"}, help="Limit #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--show-rollback-info"}, help="Show instant to rollback for rollbacks", defaultValue="false") boolean showRollbackInfo, @ShellOption(value={"--show-time-seconds"}, help="Show seconds in instant file modification time", defaultValue="false") boolean showTimeSeconds) {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        try {
            return this.printTimelineInfo(metaClient.getActiveTimeline().filterInflightsAndRequested(), this.getInstantInfoFromTimeline(metaClient, metaClient.getStorage(), metaClient.getTimelinePath()), limit, sortByField, descending, headerOnly, true, showTimeSeconds, showRollbackInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @ShellMethod(key={"metadata timeline show active"}, value="List all instants in active timeline of metadata table")
    public String metadataShowActive(@ShellOption(value={"--limit"}, help="Limit #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--show-time-seconds"}, help="Show seconds in instant file modification time", defaultValue="false") boolean showTimeSeconds) {
        HoodieTableMetaClient metaClient = this.getMetadataTableMetaClient(HoodieCLI.getTableMetaClient());
        try {
            return this.printTimelineInfo((HoodieTimeline)metaClient.getActiveTimeline(), this.getInstantInfoFromTimeline(metaClient, metaClient.getStorage(), metaClient.getTimelinePath()), limit, sortByField, descending, headerOnly, true, showTimeSeconds, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @ShellMethod(key={"metadata timeline show incomplete"}, value="List all incomplete instants in active timeline of metadata table")
    public String metadataShowIncomplete(@ShellOption(value={"--limit"}, help="Limit #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--show-time-seconds"}, help="Show seconds in instant file modification time", defaultValue="false") boolean showTimeSeconds) {
        HoodieTableMetaClient metaClient = this.getMetadataTableMetaClient(HoodieCLI.getTableMetaClient());
        try {
            return this.printTimelineInfo(metaClient.getActiveTimeline().filterInflightsAndRequested(), this.getInstantInfoFromTimeline(metaClient, metaClient.getStorage(), metaClient.getTimelinePath()), limit, sortByField, descending, headerOnly, true, showTimeSeconds, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private HoodieTableMetaClient getMetadataTableMetaClient(HoodieTableMetaClient metaClient) {
        return HoodieTableMetaClient.builder().setConf(HoodieCLI.conf.newInstance()).setBasePath(HoodieTableMetadata.getMetadataTableBasePath((StoragePath)metaClient.getBasePath())).setLoadActiveTimelineOnLoad(false).setConsistencyGuardConfig(HoodieCLI.consistencyGuardConfig).build();
    }

    private Map<String, Map<HoodieInstant.State, HoodieInstantWithModTime>> getInstantInfoFromTimeline(HoodieTableMetaClient metaClient, HoodieStorage storage, StoragePath metaPath) throws IOException {
        HashMap<String, Map<HoodieInstant.State, HoodieInstantWithModTime>> instantMap = new HashMap<String, Map<HoodieInstant.State, HoodieInstantWithModTime>>();
        InstantFileNameParser instantFileNameParser = metaClient.getInstantFileNameParser();
        InstantComparator instantComparator = metaClient.getTimelineLayout().getInstantComparator();
        InstantGenerator instantGenerator = metaClient.getInstantGenerator();
        Stream<HoodieInstantWithModTime> instantStream = HoodieTableMetaClient.scanFiles((HoodieStorage)storage, (StoragePath)metaPath, (StoragePathFilter & Serializable)path -> {
            String extension = instantFileNameParser.getTimelineFileExtension(path.getName());
            return metaClient.getActiveTimeline().getValidExtensionsInActiveTimeline().contains(extension);
        }).stream().map(storagePathInfo -> new HoodieInstantWithModTime((StoragePathInfo)storagePathInfo, instantGenerator, instantComparator));
        instantStream.forEach(instant -> instantMap.computeIfAbsent(instant.requestedTime(), t -> new HashMap()).put(instant.getState(), instant));
        return instantMap;
    }

    private String getFormattedDate(String instantTimestamp, HoodieInstant.State state, Map<String, Map<HoodieInstant.State, HoodieInstantWithModTime>> instantInfoMap, boolean showTimeSeconds) {
        Long timeMs = null;
        Map<HoodieInstant.State, HoodieInstantWithModTime> mapping = instantInfoMap.get(instantTimestamp);
        if (mapping != null && mapping.containsKey(state)) {
            timeMs = mapping.get(state).getModificationTime();
        }
        SimpleDateFormat sdf = showTimeSeconds ? DATE_FORMAT_SECONDS : DATE_FORMAT_DEFAULT;
        return timeMs != null ? sdf.format(new Date(timeMs)) : "-";
    }

    private String printTimelineInfo(HoodieTimeline timeline, Map<String, Map<HoodieInstant.State, HoodieInstantWithModTime>> instantInfoMap, Integer limit, String sortByField, boolean descending, boolean headerOnly, boolean withRowNo, boolean showTimeSeconds, boolean showRollbackInfo) {
        Map<String, List<String>> rollbackInfoMap = this.getRolledBackInstantInfo(timeline);
        List<Comparable[]> rows = timeline.getInstantsAsStream().map(instant -> {
            Comparable[] row = new Comparable[6];
            String instantTimestamp = instant.requestedTime();
            String rollbackInfoString = showRollbackInfo ? this.getRollbackInfoString((Option<HoodieInstant>)Option.of((Object)instant), timeline, rollbackInfoMap) : "";
            row[0] = instantTimestamp;
            row[1] = instant.getAction() + rollbackInfoString;
            row[2] = instant.getState();
            row[3] = this.getFormattedDate(instantTimestamp, HoodieInstant.State.REQUESTED, instantInfoMap, showTimeSeconds);
            row[4] = this.getFormattedDate(instantTimestamp, HoodieInstant.State.INFLIGHT, instantInfoMap, showTimeSeconds);
            row[5] = this.getFormattedDate(instantTimestamp, HoodieInstant.State.COMPLETED, instantInfoMap, showTimeSeconds);
            return row;
        }).collect(Collectors.toList());
        TableHeader header = new TableHeader().addTableHeaderField("Instant").addTableHeaderField("Action").addTableHeaderField("State").addTableHeaderField("Requested\nTime").addTableHeaderField("Inflight\nTime").addTableHeaderField("Completed\nTime");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), withRowNo, sortByField, descending, limit, headerOnly, rows);
    }

    private String printTimelineInfoWithMetadataTable(HoodieTimeline dtTimeline, HoodieTimeline mtTimeline, Map<String, Map<HoodieInstant.State, HoodieInstantWithModTime>> dtInstantInfoMap, Map<String, Map<HoodieInstant.State, HoodieInstantWithModTime>> mtInstantInfoMap, Integer limit, String sortByField, boolean descending, boolean headerOnly, boolean withRowNo, boolean showTimeSeconds, boolean showRollbackInfo) {
        HashSet<String> instantTimeSet = new HashSet<String>(dtInstantInfoMap.keySet());
        instantTimeSet.addAll(mtInstantInfoMap.keySet());
        List instantTimeList = instantTimeSet.stream().sorted(new HoodieInstantTimeComparator()).collect(Collectors.toList());
        Map<String, List<String>> dtRollbackInfoMap = this.getRolledBackInstantInfo(dtTimeline);
        Map<String, List<String>> mtRollbackInfoMap = this.getRolledBackInstantInfo(mtTimeline);
        List<Comparable[]> rows = instantTimeList.stream().map(instantTimestamp -> {
            Option<HoodieInstant> dtInstant = this.getInstant(dtTimeline, (String)instantTimestamp);
            Option<HoodieInstant> mtInstant = this.getInstant(mtTimeline, (String)instantTimestamp);
            Comparable[] row = new Comparable[11];
            row[0] = instantTimestamp;
            String dtRollbackInfoString = showRollbackInfo ? this.getRollbackInfoString(dtInstant, dtTimeline, dtRollbackInfoMap) : "";
            row[1] = (dtInstant.isPresent() ? ((HoodieInstant)dtInstant.get()).getAction() : "-") + dtRollbackInfoString;
            row[2] = dtInstant.isPresent() ? ((HoodieInstant)dtInstant.get()).getState() : "-";
            row[3] = this.getFormattedDate((String)instantTimestamp, HoodieInstant.State.REQUESTED, dtInstantInfoMap, showTimeSeconds);
            row[4] = this.getFormattedDate((String)instantTimestamp, HoodieInstant.State.INFLIGHT, dtInstantInfoMap, showTimeSeconds);
            row[5] = this.getFormattedDate((String)instantTimestamp, HoodieInstant.State.COMPLETED, dtInstantInfoMap, showTimeSeconds);
            String mtRollbackInfoString = showRollbackInfo ? this.getRollbackInfoString(mtInstant, mtTimeline, mtRollbackInfoMap) : "";
            row[6] = (mtInstant.isPresent() ? ((HoodieInstant)mtInstant.get()).getAction() : "-") + mtRollbackInfoString;
            row[7] = mtInstant.isPresent() ? ((HoodieInstant)mtInstant.get()).getState() : "-";
            row[8] = this.getFormattedDate((String)instantTimestamp, HoodieInstant.State.REQUESTED, mtInstantInfoMap, showTimeSeconds);
            row[9] = this.getFormattedDate((String)instantTimestamp, HoodieInstant.State.INFLIGHT, mtInstantInfoMap, showTimeSeconds);
            row[10] = this.getFormattedDate((String)instantTimestamp, HoodieInstant.State.COMPLETED, mtInstantInfoMap, showTimeSeconds);
            return row;
        }).collect(Collectors.toList());
        TableHeader header = new TableHeader().addTableHeaderField("Instant").addTableHeaderField("Action").addTableHeaderField("State").addTableHeaderField("Requested\nTime").addTableHeaderField("Inflight\nTime").addTableHeaderField("Completed\nTime").addTableHeaderField("MT\nAction").addTableHeaderField("MT\nState").addTableHeaderField("MT\nRequested\nTime").addTableHeaderField("MT\nInflight\nTime").addTableHeaderField("MT\nCompleted\nTime");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), withRowNo, sortByField, descending, limit, headerOnly, rows);
    }

    private Option<HoodieInstant> getInstant(HoodieTimeline timeline, String instantTimestamp) {
        return timeline.filter(instant -> instant.requestedTime().equals(instantTimestamp)).firstInstant();
    }

    private String getInstantToRollback(HoodieTimeline timeline, HoodieInstant instant) {
        try {
            if (instant.isInflight()) {
                HoodieInstant instantToUse = HoodieCLI.getTableMetaClient().createNewInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.requestedTime());
                HoodieRollbackPlan metadata = timeline.readRollbackPlan(instantToUse);
                return metadata.getInstantToRollback().getCommitTime();
            }
            HoodieRollbackMetadata metadata = timeline.readRollbackMetadata(instant);
            return String.join((CharSequence)",", metadata.getCommitsRollback());
        }
        catch (IOException e) {
            LOG.error(String.format("Error reading rollback info of %s", instant));
            e.printStackTrace();
            return "-";
        }
    }

    private Map<String, List<String>> getRolledBackInstantInfo(HoodieTimeline timeline) {
        HashMap<String, List<String>> rollbackInfoMap = new HashMap<String, List<String>>();
        List rollbackInstants = timeline.filter(instant -> "rollback".equalsIgnoreCase(instant.getAction())).getInstants();
        rollbackInstants.forEach(rollbackInstant -> {
            try {
                if (rollbackInstant.isInflight()) {
                    HoodieInstant instantToUse = HoodieCLI.getTableMetaClient().createNewInstant(HoodieInstant.State.REQUESTED, rollbackInstant.getAction(), rollbackInstant.requestedTime());
                    HoodieRollbackPlan metadata = timeline.readRollbackPlan(instantToUse);
                    rollbackInfoMap.computeIfAbsent(metadata.getInstantToRollback().getCommitTime(), k -> new ArrayList()).add(rollbackInstant.requestedTime());
                } else {
                    HoodieRollbackMetadata metadata = timeline.readRollbackMetadata(rollbackInstant);
                    metadata.getCommitsRollback().forEach(instant -> rollbackInfoMap.computeIfAbsent((String)instant, k -> new ArrayList()).add(rollbackInstant.requestedTime()));
                }
            }
            catch (IOException e) {
                LOG.error(String.format("Error reading rollback info of %s", rollbackInstant));
                e.printStackTrace();
            }
        });
        return rollbackInfoMap;
    }

    private String getRollbackInfoString(Option<HoodieInstant> instant, HoodieTimeline timeline, Map<String, List<String>> rollbackInfoMap) {
        String rollbackInfoString = "";
        if (instant.isPresent()) {
            if ("rollback".equalsIgnoreCase(((HoodieInstant)instant.get()).getAction())) {
                rollbackInfoString = "\nRolls back\n" + this.getInstantToRollback(timeline, (HoodieInstant)instant.get());
            } else {
                String instantTimestamp = ((HoodieInstant)instant.get()).requestedTime();
                if (rollbackInfoMap.containsKey(instantTimestamp)) {
                    rollbackInfoString = "\nRolled back by\n" + String.join((CharSequence)",\n", (Iterable<? extends CharSequence>)rollbackInfoMap.get(instantTimestamp));
                }
            }
        }
        return rollbackInfoString;
    }

    static class HoodieInstantTimeComparator
    implements Comparator<String> {
        HoodieInstantTimeComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() != o2.length()) {
                if (o1.length() - o2.length() == 3 && o1.endsWith("001") && o1.startsWith(o2)) {
                    return -1;
                }
                if (o2.length() - o1.length() == 3 && o2.endsWith("001") && o2.startsWith(o1)) {
                    return 1;
                }
            }
            return o1.compareTo(o2);
        }
    }

    static class HoodieInstantWithModTime
    extends HoodieInstant {
        private final long modificationTimeMs;

        public HoodieInstantWithModTime(StoragePathInfo pathInfo, InstantGenerator instantGenerator, InstantComparator instantComparator) {
            this(instantGenerator.createNewInstant(pathInfo), pathInfo, instantComparator.requestedTimeOrderedComparator());
        }

        public HoodieInstantWithModTime(HoodieInstant instant, StoragePathInfo pathInfo, Comparator<HoodieInstant> comparator) {
            super(instant.getState(), instant.getAction(), instant.requestedTime(), instant.getCompletionTime(), comparator);
            this.modificationTimeMs = pathInfo.getModificationTime();
        }

        public long getModificationTime() {
            return this.modificationTimeMs;
        }
    }
}

