/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SparkMetadataWriterFactory;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class MetadataCommand {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataCommand.class);
    private static String metadataBaseDirectory;
    private JavaSparkContext jsc;

    public static void setMetadataBaseDirectory(String metadataDir) {
        ValidationUtils.checkState((metadataBaseDirectory == null ? 1 : 0) != 0, (String)("metadataBaseDirectory is already set to " + metadataBaseDirectory));
        metadataBaseDirectory = metadataDir;
    }

    public static String getMetadataTableBasePath(String tableBasePath) {
        if (metadataBaseDirectory != null) {
            return metadataBaseDirectory;
        }
        return HoodieTableMetadata.getMetadataTableBasePath((String)tableBasePath);
    }

    @ShellMethod(key={"metadata set"}, value="Set options for Metadata Table")
    public String set(@ShellOption(value={"--metadataDir"}, help="Directory to read/write metadata table (can be different from dataset)", defaultValue="") String metadataDir) {
        if (!metadataDir.isEmpty()) {
            MetadataCommand.setMetadataBaseDirectory(metadataDir);
        }
        return "Ok";
    }

    @ShellMethod(key={"metadata create"}, value="Create the Metadata Table if it does not exist")
    public String create(@ShellOption(value={"--sparkMaster"}, defaultValue="yarn", help="Spark master") String master) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        StoragePath metadataPath = new StoragePath(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            List pathInfoList = HoodieCLI.storage.listDirectEntries(metadataPath);
            if (pathInfoList.size() > 0) {
                throw new RuntimeException("Metadata directory (" + metadataPath + ") not empty.");
            }
        }
        catch (FileNotFoundException e) {
            HoodieCLI.storage.createDirectory(metadataPath);
        }
        HoodieTimer timer = HoodieTimer.start();
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        this.initJavaSparkContext((Option<String>)Option.of((Object)master));
        try (HoodieTableMetadataWriter writer = SparkMetadataWriterFactory.create(HoodieCLI.conf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), (HoodieTableConfig)metaClient.getTableConfig());){
            String string = String.format("Created Metadata Table in %s (duration=%.2f secs)", metadataPath, (double)timer.endTimer() / 1000.0);
            return string;
        }
    }

    @ShellMethod(key={"metadata delete"}, value="Remove the Metadata Table")
    public String delete(@ShellOption(value={"--backup"}, help="Backup the metadata table before delete", defaultValue="true", arity=1) boolean backup) throws Exception {
        HoodieTableMetaClient dataMetaClient = HoodieCLI.getTableMetaClient();
        String backupPath = HoodieTableMetadataUtil.deleteMetadataTable((HoodieTableMetaClient)dataMetaClient, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), (boolean)backup);
        if (backup) {
            return "Metadata Table has been deleted and backed up to " + backupPath;
        }
        return "Metadata Table has been deleted from " + MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath);
    }

    @ShellMethod(key={"metadata delete-record-index"}, value="Delete the record index from Metadata Table")
    public String deleteRecordIndex(@ShellOption(value={"--backup"}, help="Backup the record index before delete", defaultValue="true", arity=1) boolean backup) throws Exception {
        HoodieTableMetaClient dataMetaClient = HoodieCLI.getTableMetaClient();
        String backupPath = HoodieTableMetadataUtil.deleteMetadataTablePartition((HoodieTableMetaClient)dataMetaClient, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), (String)MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (boolean)backup);
        if (backup) {
            return "Record Index has been deleted from the Metadata Table and backed up to " + backupPath;
        }
        return "Record Index has been deleted from the Metadata Table";
    }

    @ShellMethod(key={"metadata init"}, value="Update the metadata table from commits since the creation")
    public String init(@ShellOption(value={"--sparkMaster"}, defaultValue="yarn", help="Spark master") String master, @ShellOption(value={"--readonly"}, defaultValue="false", help="Open in read-only mode") boolean readOnly) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        StoragePath metadataPath = new StoragePath(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            HoodieCLI.storage.listDirectEntries(metadataPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Metadata directory (" + metadataPath + ") does not exist.");
        }
        HoodieTimer timer = HoodieTimer.start();
        if (!readOnly) {
            HoodieWriteConfig writeConfig = this.getWriteConfig();
            this.initJavaSparkContext((Option<String>)Option.of((Object)master));
            HoodieTableMetadataWriter writer = SparkMetadataWriterFactory.create(HoodieCLI.conf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), (HoodieTableConfig)metaClient.getTableConfig());
            Throwable throwable = null;
            if (writer != null) {
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    writer.close();
                }
            }
        }
        String action = readOnly ? "Opened" : "Initialized";
        return String.format(action + " Metadata Table in %s (duration=%.2fsec)", metadataPath, (double)timer.endTimer() / 1000.0);
    }

    @ShellMethod(key={"metadata stats"}, value="Print stats about the metadata")
    public String stats() throws IOException {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        try (HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), metaClient.getStorage(), config, HoodieCLI.basePath);){
            Map stats = metadata.stats();
            ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
            for (Map.Entry entry : stats.entrySet()) {
                Comparable[] row = new Comparable[]{(Comparable)entry.getKey(), (Comparable)entry.getValue()};
                rows.add(row);
            }
            TableHeader header = new TableHeader().addTableHeaderField("stat key").addTableHeaderField("stat value");
            String string = HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
            return string;
        }
    }

    @ShellMethod(key={"metadata list-partitions"}, value="List all partitions from metadata")
    public String listPartitions(@ShellOption(value={"--sparkMaster"}, defaultValue="yarn", help="Spark master") String master) throws IOException {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        this.initJavaSparkContext((Option<String>)Option.of((Object)master));
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        try (HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), metaClient.getStorage(), config, HoodieCLI.basePath);){
            if (!metadata.enabled()) {
                String string = "[ERROR] Metadata Table not enabled/initialized\n\n";
                return string;
            }
            HoodieTimer timer = HoodieTimer.start();
            List partitions = metadata.getAllPartitionPaths();
            LOG.debug("Metadata Partition listing took " + timer.endTimer() + " ms");
            ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
            partitions.stream().sorted(Comparator.reverseOrder()).forEach(p -> {
                Comparable[] row = new Comparable[]{p};
                rows.add(row);
            });
            TableHeader header = new TableHeader().addTableHeaderField("partition");
            String string = HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
            return string;
        }
    }

    @ShellMethod(key={"metadata list-files"}, value="Print a list of all files in a partition from the metadata")
    public String listFiles(@ShellOption(value={"--partition"}, help="Name of the partition to list files", defaultValue="") String partition) throws IOException {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        try (HoodieBackedTableMetadata metaReader = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), metaClient.getStorage(), config, HoodieCLI.basePath);){
            if (!metaReader.enabled()) {
                String string = "[ERROR] Metadata Table not enabled/initialized\n\n";
                return string;
            }
            StoragePath partitionPath = new StoragePath(HoodieCLI.basePath);
            if (!StringUtils.isNullOrEmpty((String)partition)) {
                partitionPath = new StoragePath(HoodieCLI.basePath, partition);
            }
            HoodieTimer timer = HoodieTimer.start();
            List pathInfoList = metaReader.getAllFilesInPartition(partitionPath);
            LOG.debug("Took " + timer.endTimer() + " ms");
            ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
            pathInfoList.stream().sorted((p1, p2) -> p2.getPath().getName().compareTo(p1.getPath().getName())).forEach(f -> {
                Comparable[] row = new Comparable[]{f};
                rows.add(row);
            });
            TableHeader header = new TableHeader().addTableHeaderField("file path");
            String string = HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
            return string;
        }
    }

    @ShellMethod(key={"metadata validate-files"}, value="Validate all files in all partitions from the metadata")
    public String validateFiles(@ShellOption(value={"--verbose"}, help="Print all file details", defaultValue="false") boolean verbose) throws IOException {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadataReader = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), metaClient.getStorage(), config, HoodieCLI.basePath);
        if (!metadataReader.enabled()) {
            return "[ERROR] Metadata Table not enabled/initialized\n\n";
        }
        FileSystemBackedTableMetadata fsMetaReader = new FileSystemBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), metaClient.getTableConfig(), metaClient.getStorage(), HoodieCLI.basePath);
        HoodieMetadataConfig fsConfig = HoodieMetadataConfig.newBuilder().enable(false).build();
        HoodieTimer timer = HoodieTimer.start();
        List metadataPartitions = metadataReader.getAllPartitionPaths();
        LOG.debug("Metadata Listing partitions Took " + timer.endTimer() + " ms");
        List fsPartitions = fsMetaReader.getAllPartitionPaths();
        Collections.sort(fsPartitions);
        Collections.sort(metadataPartitions);
        HashSet allPartitions = new HashSet();
        allPartitions.addAll(fsPartitions);
        allPartitions.addAll(metadataPartitions);
        if (!fsPartitions.equals(metadataPartitions)) {
            LOG.error("FS partition listing is not matching with metadata partition listing!");
            LOG.error("All FS partitions: " + Arrays.toString(fsPartitions.toArray()));
            LOG.error("All Metadata partitions: " + Arrays.toString(metadataPartitions.toArray()));
        }
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (String partition : allPartitions) {
            HashMap pathInfoMap = new HashMap();
            HashMap metadataPathInfoMap = new HashMap();
            List metadataPathInfoList = metadataReader.getAllFilesInPartition(new StoragePath(HoodieCLI.basePath, partition));
            metadataPathInfoList.forEach(entry -> metadataPathInfoMap.put(entry.getPath().getName(), entry));
            List pathInfoList = fsMetaReader.getAllFilesInPartition(new StoragePath(HoodieCLI.basePath, partition));
            pathInfoList.forEach(entry -> pathInfoMap.put(entry.getPath().getName(), entry));
            HashSet allFiles = new HashSet();
            allFiles.addAll(pathInfoMap.keySet());
            allFiles.addAll(metadataPathInfoMap.keySet());
            for (String string : allFiles) {
                Comparable[] row = new Comparable[6];
                row[0] = partition;
                StoragePathInfo pathInfo = (StoragePathInfo)pathInfoMap.get(string);
                StoragePathInfo metaPathInfo = (StoragePathInfo)metadataPathInfoMap.get(string);
                boolean doesFsFileExists = pathInfo != null;
                boolean doesMetadataFileExists = metaPathInfo != null;
                long fsFileLength = doesFsFileExists ? pathInfo.getLength() : 0L;
                long metadataFileLength = doesMetadataFileExists ? metaPathInfo.getLength() : 0L;
                row[1] = string;
                row[2] = Boolean.valueOf(doesFsFileExists);
                row[3] = Boolean.valueOf(doesMetadataFileExists);
                row[4] = Long.valueOf(fsFileLength);
                row[5] = Long.valueOf(metadataFileLength);
                if (verbose) {
                    rows.add(row);
                    continue;
                }
                if (doesFsFileExists == doesMetadataFileExists && fsFileLength == metadataFileLength) continue;
                rows.add(row);
            }
            if (metadataPathInfoList.size() != pathInfoList.size()) {
                LOG.error(" FS and metadata files count not matching for " + partition + ". FS files count " + pathInfoList.size() + ", metadata base files count " + metadataPathInfoList.size());
            }
            for (Map.Entry entry2 : pathInfoMap.entrySet()) {
                if (!metadataPathInfoMap.containsKey(entry2.getKey())) {
                    LOG.error("FS file not found in metadata " + (String)entry2.getKey());
                    continue;
                }
                if (((StoragePathInfo)entry2.getValue()).getLength() == ((StoragePathInfo)metadataPathInfoMap.get(entry2.getKey())).getLength()) continue;
                LOG.error(" FS file size mismatch " + (String)entry2.getKey() + ", size equality " + (((StoragePathInfo)entry2.getValue()).getLength() == ((StoragePathInfo)metadataPathInfoMap.get(entry2.getKey())).getLength()) + ". FS size " + ((StoragePathInfo)entry2.getValue()).getLength() + ", metadata size " + ((StoragePathInfo)metadataPathInfoMap.get(entry2.getKey())).getLength());
            }
            for (Map.Entry entry3 : metadataPathInfoMap.entrySet()) {
                if (!pathInfoMap.containsKey(entry3.getKey())) {
                    LOG.error("Metadata file not found in FS " + (String)entry3.getKey());
                    continue;
                }
                if (((StoragePathInfo)entry3.getValue()).getLength() == ((StoragePathInfo)pathInfoMap.get(entry3.getKey())).getLength()) continue;
                LOG.error(" Metadata file size mismatch " + (String)entry3.getKey() + ", size equality " + (((StoragePathInfo)entry3.getValue()).getLength() == ((StoragePathInfo)pathInfoMap.get(entry3.getKey())).getLength()) + ". Metadata size " + ((StoragePathInfo)entry3.getValue()).getLength() + ", FS size " + ((StoragePathInfo)metadataPathInfoMap.get(entry3.getKey())).getLength());
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("Partition").addTableHeaderField("File Name").addTableHeaderField(" Is Present in FS ").addTableHeaderField(" Is Present in Metadata").addTableHeaderField(" FS size").addTableHeaderField(" Metadata size");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
    }

    private HoodieWriteConfig getWriteConfig() {
        return HoodieWriteConfig.newBuilder().withPath(HoodieCLI.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
    }

    private void initJavaSparkContext(Option<String> userDefinedMaster) {
        if (this.jsc == null) {
            this.jsc = SparkUtil.initJavaSparkContext(SparkUtil.getDefaultConf("HoodieCLI", userDefinedMaster));
        }
    }
}

