/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.block.HoodieCorruptBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.Tuple2;
import scala.Tuple3;

@ShellComponent
public class HoodieLogFileCommand {
    @ShellMethod(key={"show logfile metadata"}, value="Read commit metadata from log files")
    public String showLogFileCommits(@ShellOption(value={"--logFilePathPattern"}, help="Fully qualified path for the log file") String logFilePathPattern, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) throws IOException {
        HoodieStorage storage = HoodieCLI.getTableMetaClient().getStorage();
        List logFilePaths = FSUtils.getGlobStatusExcludingMetaFolder((HoodieStorage)storage, (StoragePath)new StoragePath(logFilePathPattern)).stream().map(status -> status.getPath().toString()).collect(Collectors.toList());
        HashMap commitCountAndMetadata = new HashMap();
        int numCorruptBlocks = 0;
        int dummyInstantTimeCount = 0;
        String basePath = HoodieCLI.basePath;
        for (String logFilePath : logFilePaths) {
            String fileName;
            StoragePath path = new StoragePath(logFilePath);
            String string = path.toString();
            if (string.contains(basePath)) {
                String[] split = string.split(basePath);
                fileName = split[split.length - 1];
            } else {
                fileName = path.getName();
            }
            Schema writerSchema = TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)storage, (StoragePath)path);
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((HoodieStorage)storage, (HoodieLogFile)new HoodieLogFile(path), (Schema)writerSchema);
            Throwable throwable = null;
            try {
                while (reader.hasNext()) {
                    String instantTime;
                    HoodieLogBlock n = (HoodieLogBlock)reader.next();
                    AtomicInteger recordCount = new AtomicInteger(0);
                    if (n instanceof HoodieCorruptBlock) {
                        try {
                            instantTime = (String)n.getLogBlockHeader().get(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                            if (instantTime == null) {
                                throw new Exception("Invalid instant time " + instantTime);
                            }
                        }
                        catch (Exception e) {
                            instantTime = "corrupt_block_" + ++numCorruptBlocks;
                        }
                    } else {
                        instantTime = (String)n.getLogBlockHeader().get(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                        if (instantTime == null) {
                            instantTime = "dummy_instant_time_" + ++dummyInstantTimeCount;
                        }
                        if (n instanceof HoodieDataBlock) {
                            try (ClosableIterator recordItr = ((HoodieDataBlock)n).getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);){
                                recordItr.forEachRemaining(r -> recordCount.incrementAndGet());
                            }
                        }
                    }
                    if (commitCountAndMetadata.containsKey(instantTime)) {
                        ((List)commitCountAndMetadata.get(instantTime)).add(new Tuple3((Object)new Tuple2((Object)fileName, (Object)n.getBlockType()), (Object)new Tuple2((Object)n.getLogBlockHeader(), (Object)n.getLogBlockFooter()), (Object)recordCount.get()));
                        continue;
                    }
                    ArrayList<Tuple3> list = new ArrayList<Tuple3>();
                    list.add(new Tuple3((Object)new Tuple2((Object)fileName, (Object)n.getBlockType()), (Object)new Tuple2((Object)n.getLogBlockHeader(), (Object)n.getLogBlockFooter()), (Object)recordCount.get()));
                    commitCountAndMetadata.put(instantTime, list);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (Map.Entry entry : commitCountAndMetadata.entrySet()) {
            String instantTime = (String)entry.getKey();
            for (Tuple3 tuple3 : (List)entry.getValue()) {
                Comparable[] output = new Comparable[]{(Comparable)((Tuple2)tuple3._1())._1(), instantTime, (Comparable)tuple3._3(), ((HoodieLogBlock.HoodieLogBlockType)((Tuple2)tuple3._1())._2()).toString(), objectMapper.writeValueAsString(((Tuple2)tuple3._2())._1()), objectMapper.writeValueAsString(((Tuple2)tuple3._2())._2())};
                rows.add(output);
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("File Path").addTableHeaderField("InstantTime").addTableHeaderField("RecordCount").addTableHeaderField("BlockType").addTableHeaderField("HeaderMetadata").addTableHeaderField("FooterMetadata");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShellMethod(key={"show logfile records"}, value="Read records from log files")
    public String showLogFileRecords(@ShellOption(value={"--limit"}, help="Limit commits", defaultValue="10") Integer limit, @ShellOption(value={"--logFilePathPattern"}, help="Fully qualified paths for the log files") String logFilePathPattern, @ShellOption(value={"--mergeRecords"}, help="If the records in the log files should be merged", defaultValue="false") Boolean shouldMerge) throws IOException {
        System.out.println("===============> Showing only " + limit + " records <===============");
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        HoodieStorage storage = client.getStorage();
        List logFilePaths = FSUtils.getGlobStatusExcludingMetaFolder((HoodieStorage)storage, (StoragePath)new StoragePath(logFilePathPattern)).stream().map(status -> status.getPath().toString()).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        ValidationUtils.checkArgument((logFilePaths.size() > 0 ? 1 : 0) != 0, (String)"There is no log file");
        Schema readerSchema = null;
        for (int i = logFilePaths.size() - 1; i >= 0; --i) {
            Schema schema = TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)storage, (StoragePath)new StoragePath((String)logFilePaths.get(i)));
            if (schema == null) continue;
            readerSchema = schema;
            break;
        }
        Objects.requireNonNull(readerSchema);
        ArrayList<Object> allRecords = new ArrayList<Object>();
        if (shouldMerge.booleanValue()) {
            System.out.println("===========================> MERGING RECORDS <===================");
            HoodieMergedLogRecordScanner scanner = HoodieMergedLogRecordScanner.newBuilder().withStorage(storage).withBasePath(client.getBasePath()).withLogFilePaths(logFilePaths).withReaderSchema(readerSchema).withLatestInstantTime(((HoodieInstant)client.getActiveTimeline().getCommitAndReplaceTimeline().lastInstant().get()).requestedTime()).withReverseReader(Boolean.parseBoolean((String)HoodieReaderConfig.COMPACTION_REVERSE_LOG_READ_ENABLE.defaultValue())).withBufferSize(((Integer)HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE.defaultValue()).intValue()).withMaxMemorySizeInBytes(Long.valueOf(0x40000000L)).withSpillableMapBasePath(FileIOUtils.getDefaultSpillableMapBasePath()).withDiskMapType((ExternalSpillableMap.DiskMapType)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue()).withBitCaskDiskMapCompressionEnabled(((Boolean)HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue()).booleanValue()).withOptimizedLogBlocksScan(Boolean.parseBoolean((String)HoodieReaderConfig.ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN.defaultValue())).build();
            for (HoodieRecord hoodieRecord : scanner) {
                Option option = hoodieRecord.toIndexedRecord(readerSchema, new Properties());
                if (allRecords.size() >= limit) continue;
                allRecords.add(((HoodieAvroIndexedRecord)option.get()).getData());
            }
        } else {
            for (String logFile : logFilePaths) {
                Schema writerSchema = TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)client.getStorage(), (StoragePath)new StoragePath(logFile));
                try (HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((HoodieStorage)storage, (HoodieLogFile)new HoodieLogFile(new StoragePath(logFile)), (Schema)writerSchema);){
                    while (reader.hasNext()) {
                        ClosableIterator recordItr;
                        block29: {
                            HoodieLogBlock n = (HoodieLogBlock)reader.next();
                            if (!(n instanceof HoodieDataBlock)) continue;
                            HoodieDataBlock blk = (HoodieDataBlock)n;
                            recordItr = blk.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                            Throwable throwable = null;
                            try {
                                recordItr.forEachRemaining(record -> {
                                    if (allRecords.size() < limit) {
                                        allRecords.add(record.getData());
                                    }
                                });
                                if (recordItr == null) continue;
                                if (throwable == null) break block29;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (recordItr == null) throw throwable3;
                                    if (throwable == null) {
                                        recordItr.close();
                                        throw throwable3;
                                    }
                                    try {
                                        recordItr.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                recordItr.close();
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                continue;
                            }
                        }
                        recordItr.close();
                    }
                }
                if (allRecords.size() < limit) continue;
            }
        }
        String[][] rows = new String[allRecords.size()][];
        int i = 0;
        Iterator iterator = allRecords.iterator();
        while (iterator.hasNext()) {
            IndexedRecord indexedRecord = (IndexedRecord)iterator.next();
            String[] data = new String[]{indexedRecord.toString()};
            rows[i] = data;
            ++i;
        }
        return HoodiePrintHelper.print(new String[]{"Records"}, rows);
    }
}

