/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.utilities.HDFSParquetImporter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.util.Utils;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.collection.JavaConverters;
import scala.collection.Map;

@ShellComponent
public class HDFSParquetImportCommand {
    @ShellMethod(key={"hdfsparquetimport"}, value="Imports Parquet table to a hoodie table")
    public String convert(@ShellOption(value={"--upsert"}, defaultValue="false", help="Uses upsert API instead of the default insert API of WriteClient") boolean useUpsert, @ShellOption(value={"--srcPath"}, help="Base path for the input table") String srcPath, @ShellOption(value={"--targetPath"}, help="Base path for the target hoodie table") String targetPath, @ShellOption(value={"--tableName"}, help="Table name") String tableName, @ShellOption(value={"--tableType"}, help="Table type") String tableType, @ShellOption(value={"--rowKeyField"}, help="Row key field name") String rowKeyField, @ShellOption(value={"--partitionPathField"}, defaultValue="", help="Partition path field name") String partitionPathField, @ShellOption(value={"--parallelism"}, help="Parallelism for hoodie insert") String parallelism, @ShellOption(value={"--schemaFilePath"}, help="Path for Avro schema file") String schemaFilePath, @ShellOption(value={"--format"}, help="Format for the input data") String format, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, help="Spark executor memory") String sparkMemory, @ShellOption(value={"--retry"}, help="Number of retries") String retry, @ShellOption(value={"--propsFilePath"}, help="path to properties file on localfs or dfs with configurations for hoodie client for importing", defaultValue="") String propsFilePath, @ShellOption(value={"--hoodieConfigs"}, help="Any configuration that can be set in the properties file can be passed here in the form of an array", defaultValue="") String[] configs) throws Exception {
        new HDFSParquetImporter.FormatValidator().validate("format", format);
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.SparkCommand cmd = SparkMain.SparkCommand.IMPORT;
        if (useUpsert) {
            cmd = SparkMain.SparkCommand.UPSERT;
        }
        SparkMain.addAppArgs(sparkLauncher, cmd, master, sparkMemory, srcPath, targetPath, tableName, tableType, rowKeyField, partitionPathField, parallelism, schemaFilePath, retry, propsFilePath);
        UtilHelpers.validateAndAddProperties((String[])configs, (SparkLauncher)sparkLauncher);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to import table to hoodie format";
        }
        return "Table imported to hoodie format";
    }
}

