/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;

public class CommitUtil {
    public static long countNewRecords(HoodieTableMetaClient target, List<String> commitsToCatchup) throws IOException {
        long totalNew = 0L;
        HoodieTimeline timeline = target.getActiveTimeline().reload().getCommitTimeline().filterCompletedInstants();
        for (String commit : commitsToCatchup) {
            HoodieCommitMetadata c = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails(new HoodieInstant(false, "commit", commit)).get()), HoodieCommitMetadata.class);
            totalNew += c.fetchTotalRecordsWritten() - c.fetchTotalUpdateRecordsWritten();
        }
        return totalNew;
    }
}

