/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class SavepointsCommand
implements CommandMarker {
    @CliAvailabilityIndicator(value={"savepoints show"})
    public boolean isShowAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliAvailabilityIndicator(value={"savepoints refresh"})
    public boolean isRefreshAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliAvailabilityIndicator(value={"savepoint create"})
    public boolean isCreateSavepointAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliAvailabilityIndicator(value={"savepoint rollback"})
    public boolean isRollbackToSavepointAvailable() {
        return HoodieCLI.tableMetadata != null && !HoodieCLI.tableMetadata.getActiveTimeline().getSavePointTimeline().filterCompletedInstants().empty();
    }

    @CliCommand(value={"savepoints show"}, help="Show the savepoints")
    public String showSavepoints() throws IOException {
        HoodieActiveTimeline activeTimeline = HoodieCLI.tableMetadata.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getSavePointTimeline().filterCompletedInstants();
        List commits = timeline.getInstants().collect(Collectors.toList());
        String[][] rows = new String[commits.size()][];
        Collections.reverse(commits);
        for (int i = 0; i < commits.size(); ++i) {
            HoodieInstant commit = (HoodieInstant)commits.get(i);
            rows[i] = new String[]{commit.getTimestamp()};
        }
        return HoodiePrintHelper.print(new String[]{"SavepointTime"}, rows);
    }

    @CliCommand(value={"savepoint create"}, help="Savepoint a commit")
    public String savepoint(@CliOption(key={"commit"}, help="Commit to savepoint") String commitTime, @CliOption(key={"user"}, help="User who is creating the savepoint") String user, @CliOption(key={"comments"}, help="Comments for creating the savepoint") String comments) throws Exception {
        HoodieInstant commitInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.tableMetadata.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", commitTime))) {
            return "Commit " + commitTime + " not found in Commits " + timeline;
        }
        HoodieWriteClient client = SavepointsCommand.createHoodieClient(null, HoodieCLI.tableMetadata.getBasePath());
        if (client.savepoint(commitTime, user, comments)) {
            this.refreshMetaClient();
            return String.format("The commit \"%s\" has been savepointed.", commitTime);
        }
        return String.format("Failed: Could not savepoint commit \"%s\".", commitTime);
    }

    @CliCommand(value={"savepoint rollback"}, help="Savepoint a commit")
    public String rollbackToSavepoint(@CliOption(key={"savepoint"}, help="Savepoint to rollback") String commitTime, @CliOption(key={"sparkProperties"}, help="Spark Properites File Path") String sparkPropertiesPath) throws Exception {
        HoodieInstant commitInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.tableMetadata.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", commitTime))) {
            return "Commit " + commitTime + " not found in Commits " + timeline;
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.ROLLBACK_TO_SAVEPOINT.toString(), commitTime, HoodieCLI.tableMetadata.getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        this.refreshMetaClient();
        if (exitCode != 0) {
            return "Savepoint " + commitTime + " failed to roll back";
        }
        return "Savepoint " + commitTime + " rolled back";
    }

    @CliCommand(value={"savepoints refresh"}, help="Refresh the savepoints")
    public String refreshMetaClient() throws IOException {
        HoodieCLI.refreshTableMetadata();
        return "Metadata for table " + HoodieCLI.tableMetadata.getTableConfig().getTableName() + " refreshed.";
    }

    private static HoodieWriteClient createHoodieClient(JavaSparkContext jsc, String basePath) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(basePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).build();
        return new HoodieWriteClient(jsc, config, false);
    }
}

