/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FSUtils;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RepairsCommand
implements CommandMarker {
    @CliAvailabilityIndicator(value={"repair deduplicate"})
    public boolean isRepairDeduplicateAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliAvailabilityIndicator(value={"repair addpartitionmeta"})
    public boolean isRepairAddPartitionMetaAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliCommand(value={"repair deduplicate"}, help="De-duplicate a partition path contains duplicates & produce repaired files to replace with")
    public String deduplicate(@CliOption(key={"duplicatedPartitionPath"}, help="Partition Path containing the duplicates", mandatory=true) String duplicatedPartitionPath, @CliOption(key={"repairedOutputPath"}, help="Location to place the repaired files", mandatory=true) String repairedOutputPath, @CliOption(key={"sparkProperties"}, help="Spark Properites File Path", mandatory=true) String sparkPropertiesPath) throws Exception {
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.DEDUPLICATE.toString(), duplicatedPartitionPath, repairedOutputPath, HoodieCLI.tableMetadata.getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Deduplicated files placed in:  " + repairedOutputPath;
        }
        return "Deduplication failed ";
    }

    @CliCommand(value={"repair addpartitionmeta"}, help="Add partition metadata to a dataset, if not present")
    public String addPartitionMeta(@CliOption(key={"dryrun"}, help="Should we actually add or just print what would be done", unspecifiedDefaultValue="true") boolean dryRun) throws IOException {
        String latestCommit = ((HoodieInstant)HoodieCLI.tableMetadata.getActiveTimeline().getCommitTimeline().lastInstant().get()).getTimestamp();
        List partitionPaths = FSUtils.getAllPartitionFoldersThreeLevelsDown((FileSystem)HoodieCLI.fs, (String)HoodieCLI.tableMetadata.getBasePath());
        Path basePath = new Path(HoodieCLI.tableMetadata.getBasePath());
        String[][] rows = new String[partitionPaths.size() + 1][];
        int ind = 0;
        for (String partition : partitionPaths) {
            Path partitionPath = FSUtils.getPartitionPath((Path)basePath, (String)partition);
            String[] row = new String[]{partition, "Yes", "None"};
            if (!HoodiePartitionMetadata.hasPartitionMetadata((FileSystem)HoodieCLI.fs, (Path)partitionPath)) {
                row[1] = "No";
                if (!dryRun) {
                    HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(HoodieCLI.fs, latestCommit, basePath, partitionPath);
                    partitionMetadata.trySave(0);
                }
            }
            rows[ind++] = row;
        }
        return HoodiePrintHelper.print(new String[]{"Partition Path", "Metadata Present?", "Action"}, rows);
    }
}

