/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.io.storage.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieCorruptBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.util.SchemaUtil;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import scala.Tuple2;
import scala.Tuple3;

@Component
public class HoodieLogFileCommand
implements CommandMarker {
    @CliAvailabilityIndicator(value={"show logfiles"})
    public boolean isShowArchivedLogFileAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliCommand(value={"show logfile metadata"}, help="Read commit metadata from log files")
    public String showLogFileCommits(@CliOption(key={"logFilePathPattern"}, mandatory=true, help="Fully qualified path for the log file") String logFilePathPattern, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        HoodieWrapperFileSystem fs = HoodieCLI.tableMetadata.getFs();
        List logFilePaths = Arrays.stream(fs.globStatus(new Path(logFilePathPattern))).map(status -> status.getPath().toString()).collect(Collectors.toList());
        HashMap commitCountAndMetadata = Maps.newHashMap();
        int totalEntries = 0;
        int numCorruptBlocks = 0;
        int dummyInstantTimeCount = 0;
        for (String logFilePath : logFilePaths) {
            FileStatus[] fsStatus = fs.listStatus(new Path(logFilePath));
            Schema writerSchema = new AvroSchemaConverter().convert(SchemaUtil.readSchemaFromLogFile((FileSystem)HoodieCLI.tableMetadata.getFs(), (Path)new Path(logFilePath)));
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((FileSystem)fs, (HoodieLogFile)new HoodieLogFile(fsStatus[0].getPath()), (Schema)writerSchema);
            while (reader.hasNext()) {
                String instantTime;
                HoodieLogBlock n = (HoodieLogBlock)reader.next();
                int recordCount = 0;
                if (n instanceof HoodieCorruptBlock) {
                    try {
                        instantTime = (String)n.getLogBlockHeader().get(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                        if (instantTime == null) {
                            throw new Exception("Invalid instant time " + instantTime);
                        }
                    }
                    catch (Exception e) {
                        instantTime = "corrupt_block_" + ++numCorruptBlocks;
                    }
                } else {
                    instantTime = (String)n.getLogBlockHeader().get(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                    if (instantTime == null) {
                        instantTime = "dummy_instant_time_" + ++dummyInstantTimeCount;
                    }
                    if (n instanceof HoodieAvroDataBlock) {
                        recordCount = ((HoodieAvroDataBlock)n).getRecords().size();
                    }
                }
                if (commitCountAndMetadata.containsKey(instantTime)) {
                    ((List)commitCountAndMetadata.get(instantTime)).add(new Tuple3((Object)n.getBlockType(), (Object)new Tuple2((Object)n.getLogBlockHeader(), (Object)n.getLogBlockFooter()), (Object)recordCount));
                    ++totalEntries;
                    continue;
                }
                ArrayList<Tuple3> list = new ArrayList<Tuple3>();
                list.add(new Tuple3((Object)n.getBlockType(), (Object)new Tuple2((Object)n.getLogBlockHeader(), (Object)n.getLogBlockFooter()), (Object)recordCount));
                commitCountAndMetadata.put(instantTime, list);
                ++totalEntries;
            }
            reader.close();
        }
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        int i = 0;
        ObjectMapper objectMapper = new ObjectMapper();
        for (Map.Entry entry : commitCountAndMetadata.entrySet()) {
            String instantTime = ((String)entry.getKey()).toString();
            for (Tuple3 tuple3 : (List)entry.getValue()) {
                Comparable[] output = new Comparable[]{instantTime, (Comparable)tuple3._3(), ((HoodieLogBlock.HoodieLogBlockType)tuple3._1()).toString(), objectMapper.writeValueAsString(((Tuple2)tuple3._2())._1()), objectMapper.writeValueAsString(((Tuple2)tuple3._2())._2())};
                rows.add(output);
                ++i;
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("InstantTime").addTableHeaderField("RecordCount").addTableHeaderField("BlockType").addTableHeaderField("HeaderMetadata").addTableHeaderField("FooterMetadata");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"show logfile records"}, help="Read records from log files")
    public String showLogFileRecords(@CliOption(key={"limit"}, mandatory=false, help="Limit commits", unspecifiedDefaultValue="10") Integer limit, @CliOption(key={"logFilePathPattern"}, mandatory=true, help="Fully qualified paths for the log files") String logFilePathPattern, @CliOption(key={"mergeRecords"}, mandatory=false, help="If the records in the log files should be merged", unspecifiedDefaultValue="false") Boolean shouldMerge) throws IOException {
        System.out.println("===============> Showing only " + limit + " records <===============");
        HoodieWrapperFileSystem fs = HoodieCLI.tableMetadata.getFs();
        List logFilePaths = Arrays.stream(fs.globStatus(new Path(logFilePathPattern))).map(status -> status.getPath().toString()).collect(Collectors.toList());
        AvroSchemaConverter converter = new AvroSchemaConverter();
        Schema readerSchema = converter.convert(SchemaUtil.readSchemaFromLogFile((FileSystem)fs, (Path)new Path((String)logFilePaths.get(logFilePaths.size() - 1))));
        ArrayList<Object> allRecords = new ArrayList<Object>();
        if (shouldMerge.booleanValue()) {
            System.out.println("===========================> MERGING RECORDS <===================");
            HoodieMergedLogRecordScanner scanner = new HoodieMergedLogRecordScanner((FileSystem)fs, HoodieCLI.tableMetadata.getBasePath(), logFilePaths, readerSchema, ((HoodieInstant)HoodieCLI.tableMetadata.getActiveTimeline().getCommitTimeline().lastInstant().get()).getTimestamp(), Long.valueOf(0x40000000L), Boolean.valueOf("false").booleanValue(), Boolean.valueOf("false").booleanValue(), Integer.valueOf(0x1000000).intValue(), "/tmp/");
            for (HoodieRecord hoodieRecord : scanner) {
                Option option = hoodieRecord.getData().getInsertValue(readerSchema);
                if (allRecords.size() < limit) {
                    allRecords.add(option.get());
                    continue;
                }
                break;
            }
        } else {
            for (String logFile : logFilePaths) {
                Schema writerSchema = new AvroSchemaConverter().convert(SchemaUtil.readSchemaFromLogFile((FileSystem)HoodieCLI.tableMetadata.getFs(), (Path)new Path(logFile)));
                HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((FileSystem)fs, (HoodieLogFile)new HoodieLogFile(new Path(logFile)), (Schema)writerSchema);
                while (reader.hasNext()) {
                    HoodieLogBlock n = (HoodieLogBlock)reader.next();
                    if (!(n instanceof HoodieAvroDataBlock)) continue;
                    HoodieAvroDataBlock blk = (HoodieAvroDataBlock)n;
                    List records = blk.getRecords();
                    allRecords.addAll(records);
                    if (allRecords.size() < limit) continue;
                    break;
                }
                reader.close();
                if (allRecords.size() < limit) continue;
                break;
            }
        }
        String[][] rows = new String[allRecords.size() + 1][];
        int i = 0;
        for (IndexedRecord indexedRecord : allRecords) {
            String[] data = new String[]{indexedRecord.toString()};
            rows[i] = data;
            ++i;
        }
        return HoodiePrintHelper.print(new String[]{"Records"}, rows);
    }
}

