/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ConsistencyGuardConfig;
import org.apache.hudi.exception.DatasetNotFoundException;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class DatasetsCommand
implements CommandMarker {
    @CliCommand(value={"connect"}, help="Connect to a hoodie dataset")
    public String connect(@CliOption(key={"path"}, mandatory=true, help="Base Path of the dataset") String path, @CliOption(key={"eventuallyConsistent"}, mandatory=false, unspecifiedDefaultValue="false", help="Enable eventual consistency") boolean eventuallyConsistent, @CliOption(key={"initialCheckIntervalMs"}, mandatory=false, unspecifiedDefaultValue="2000", help="Initial wait time for eventual consistency") Integer initialConsistencyIntervalMs, @CliOption(key={"maxCheckIntervalMs"}, mandatory=false, unspecifiedDefaultValue="300000", help="Max wait time for eventual consistency") Integer maxConsistencyIntervalMs, @CliOption(key={"maxCheckIntervalMs"}, mandatory=false, unspecifiedDefaultValue="7", help="Max checks for eventual consistency") Integer maxConsistencyChecks) throws IOException {
        HoodieCLI.setConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(eventuallyConsistent).withInitialConsistencyCheckIntervalMs(initialConsistencyIntervalMs.intValue()).withMaxConsistencyCheckIntervalMs(maxConsistencyIntervalMs.intValue()).withMaxConsistencyChecks(maxConsistencyChecks.intValue()).build());
        HoodieCLI.initConf();
        HoodieCLI.connectTo(path);
        HoodieCLI.initFS(true);
        HoodieCLI.state = HoodieCLI.CLIState.DATASET;
        return "Metadata for table " + HoodieCLI.tableMetadata.getTableConfig().getTableName() + " loaded";
    }

    @CliCommand(value={"create"}, help="Create a hoodie table if not present")
    public String createTable(@CliOption(key={"path"}, mandatory=true, help="Base Path of the dataset") String path, @CliOption(key={"tableName"}, mandatory=true, help="Hoodie Table Name") String name, @CliOption(key={"tableType"}, unspecifiedDefaultValue="COPY_ON_WRITE", help="Hoodie Table Type. Must be one of : COPY_ON_WRITE or MERGE_ON_READ") String tableTypeStr, @CliOption(key={"payloadClass"}, unspecifiedDefaultValue="org.apache.hudi.common.model.HoodieAvroPayload", help="Payload Class") String payloadClass) throws IOException {
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        boolean existing = false;
        try {
            new HoodieTableMetaClient(HoodieCLI.conf, path);
            existing = true;
        }
        catch (DatasetNotFoundException datasetNotFoundException) {
            // empty catch block
        }
        if (existing) {
            throw new IllegalStateException("Dataset already existing in path : " + path);
        }
        HoodieTableType tableType = HoodieTableType.valueOf((String)tableTypeStr);
        HoodieTableMetaClient.initTableType((Configuration)HoodieCLI.conf, (String)path, (HoodieTableType)tableType, (String)name, (String)payloadClass);
        return this.connect(path, false, 0, 0, 0);
    }

    @CliAvailabilityIndicator(value={"desc"})
    public boolean isDescAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliCommand(value={"desc"}, help="Describle Hoodie Table properties")
    public String descTable() {
        TableHeader header = new TableHeader().addTableHeaderField("Property").addTableHeaderField("Value");
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rows.add(new Comparable[]{"basePath", HoodieCLI.tableMetadata.getBasePath()});
        rows.add(new Comparable[]{"metaPath", HoodieCLI.tableMetadata.getMetaPath()});
        rows.add(new Comparable[]{"fileSystem", HoodieCLI.tableMetadata.getFs().getScheme()});
        HoodieCLI.tableMetadata.getTableConfig().getProps().entrySet().forEach(e -> rows.add(new Comparable[]{(Comparable)e.getKey(), (Comparable)e.getValue()}));
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, -1, false, rows);
    }

    static {
        System.out.println("DatasetsCommand getting loaded");
    }
}

