/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.AvroUtils;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CleansCommand
implements CommandMarker {
    @CliAvailabilityIndicator(value={"cleans show"})
    public boolean isShowAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliAvailabilityIndicator(value={"cleans refresh"})
    public boolean isRefreshAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliAvailabilityIndicator(value={"clean showpartitions"})
    public boolean isCommitShowAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliCommand(value={"cleans show"}, help="Show the cleans")
    public String showCleans(@CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        HoodieActiveTimeline activeTimeline = HoodieCLI.tableMetadata.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCleanerTimeline().filterCompletedInstants();
        List cleans = timeline.getInstants().collect(Collectors.toList());
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        Collections.reverse(cleans);
        for (int i = 0; i < cleans.size(); ++i) {
            HoodieInstant clean = (HoodieInstant)cleans.get(i);
            HoodieCleanMetadata cleanMetadata = AvroUtils.deserializeHoodieCleanMetadata((byte[])((byte[])timeline.getInstantDetails(clean).get()));
            rows.add(new Comparable[]{clean.getTimestamp(), cleanMetadata.getEarliestCommitToRetain(), cleanMetadata.getTotalFilesDeleted(), cleanMetadata.getTimeTakenInMillis()});
        }
        TableHeader header = new TableHeader().addTableHeaderField("CleanTime").addTableHeaderField("EarliestCommandRetained").addTableHeaderField("Total Files Deleted").addTableHeaderField("Total Time Taken");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"cleans refresh"}, help="Refresh the commits")
    public String refreshCleans() throws IOException {
        HoodieCLI.refreshTableMetadata();
        return "Metadata for table " + HoodieCLI.tableMetadata.getTableConfig().getTableName() + " refreshed.";
    }

    @CliCommand(value={"clean showpartitions"}, help="Show partition level details of a clean")
    public String showCleanPartitions(@CliOption(key={"clean"}, help="clean to show") String commitTime, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws Exception {
        HoodieInstant cleanInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.tableMetadata.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCleanerTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(cleanInstant = new HoodieInstant(false, "clean", commitTime))) {
            return "Clean " + commitTime + " not found in metadata " + timeline;
        }
        HoodieCleanMetadata cleanMetadata = AvroUtils.deserializeHoodieCleanMetadata((byte[])((byte[])timeline.getInstantDetails(cleanInstant).get()));
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry : cleanMetadata.getPartitionMetadata().entrySet()) {
            String path = (String)entry.getKey();
            HoodieCleanPartitionMetadata stats = (HoodieCleanPartitionMetadata)entry.getValue();
            String policy = stats.getPolicy();
            Integer totalSuccessDeletedFiles = stats.getSuccessDeleteFiles().size();
            Integer totalFailedDeletedFiles = stats.getFailedDeleteFiles().size();
            rows.add(new Comparable[]{path, policy, totalSuccessDeletedFiles, totalFailedDeletedFiles});
        }
        TableHeader header = new TableHeader().addTableHeaderField("Partition Path").addTableHeaderField("Cleaning policy").addTableHeaderField("Total Files Successfully Deleted").addTableHeaderField("Total Failed Deletions");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }
}

