/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.util.FSUtils;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ArchivedCommitsCommand
implements CommandMarker {
    @CliAvailabilityIndicator(value={"show archived commits"})
    public boolean isShowArchivedCommitAvailable() {
        return HoodieCLI.tableMetadata != null;
    }

    @CliCommand(value={"show archived commit stats"}, help="Read commits from archived files and show details")
    public String showArchivedCommits(@CliOption(key={"archiveFolderPattern"}, help="Archive Folder", unspecifiedDefaultValue="") String folder, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        System.out.println("===============> Showing only " + limit + " archived commits <===============");
        String basePath = HoodieCLI.tableMetadata.getBasePath();
        Path archivePath = new Path(basePath + "/.hoodie/.commits_.archive*");
        if (folder != null && !folder.isEmpty()) {
            archivePath = new Path(basePath + "/.hoodie/" + folder);
        }
        FileStatus[] fsStatuses = FSUtils.getFs((String)basePath, (Configuration)HoodieCLI.conf).globStatus(archivePath);
        ArrayList<Comparable[]> allStats = new ArrayList<Comparable[]>();
        for (FileStatus fs : fsStatuses) {
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((FileSystem)FSUtils.getFs((String)basePath, (Configuration)HoodieCLI.conf), (HoodieLogFile)new HoodieLogFile(fs.getPath()), (Schema)HoodieArchivedMetaEntry.getClassSchema());
            ArrayList readRecords = new ArrayList();
            while (reader.hasNext()) {
                HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                List records = blk.getRecords();
                readRecords.addAll(records);
            }
            List readCommits = readRecords.stream().map(r -> (GenericRecord)r).filter(r -> r.get("actionType").toString().equals("commit") || r.get("actionType").toString().equals("deltacommit")).flatMap(r -> {
                HoodieCommitMetadata metadata = (HoodieCommitMetadata)SpecificData.get().deepCopy(HoodieCommitMetadata.SCHEMA$, r.get("hoodieCommitMetadata"));
                String instantTime = r.get("commitTime").toString();
                String action = r.get("actionType").toString();
                return metadata.getPartitionToWriteStats().values().stream().flatMap(hoodieWriteStats -> hoodieWriteStats.stream().map(hoodieWriteStat -> {
                    ArrayList<Object> row = new ArrayList<Object>();
                    row.add(action);
                    row.add(instantTime);
                    row.add(hoodieWriteStat.getPartitionPath());
                    row.add(hoodieWriteStat.getFileId());
                    row.add(hoodieWriteStat.getPrevCommit());
                    row.add(hoodieWriteStat.getNumWrites());
                    row.add(hoodieWriteStat.getNumInserts());
                    row.add(hoodieWriteStat.getNumDeletes());
                    row.add(hoodieWriteStat.getNumUpdateWrites());
                    row.add(hoodieWriteStat.getTotalLogFiles());
                    row.add(hoodieWriteStat.getTotalLogBlocks());
                    row.add(hoodieWriteStat.getTotalCorruptLogBlock());
                    row.add(hoodieWriteStat.getTotalRollbackBlocks());
                    row.add(hoodieWriteStat.getTotalLogRecords());
                    row.add(hoodieWriteStat.getTotalUpdatedRecordsCompacted());
                    row.add(hoodieWriteStat.getTotalWriteBytes());
                    row.add(hoodieWriteStat.getTotalWriteErrors());
                    return row;
                })).map(rowList -> rowList.toArray(new Comparable[0]));
            }).collect(Collectors.toList());
            allStats.addAll(readCommits);
            reader.close();
        }
        TableHeader header = new TableHeader().addTableHeaderField("action").addTableHeaderField("instant").addTableHeaderField("partition").addTableHeaderField("file_id").addTableHeaderField("prev_instant").addTableHeaderField("num_writes").addTableHeaderField("num_inserts").addTableHeaderField("num_deletes").addTableHeaderField("num_update_writes").addTableHeaderField("total_log_files").addTableHeaderField("total_log_blocks").addTableHeaderField("total_corrupt_log_blocks").addTableHeaderField("total_rollback_blocks").addTableHeaderField("total_log_records").addTableHeaderField("total_updated_records_compacted").addTableHeaderField("total_write_bytes").addTableHeaderField("total_write_errors");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, allStats);
    }

    @CliCommand(value={"show archived commits"}, help="Read commits from archived files and show details")
    public String showCommits(@CliOption(key={"skipMetadata"}, help="Skip displaying commit metadata", unspecifiedDefaultValue="true") boolean skipMetadata, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="10") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        System.out.println("===============> Showing only " + limit + " archived commits <===============");
        String basePath = HoodieCLI.tableMetadata.getBasePath();
        FileStatus[] fsStatuses = FSUtils.getFs((String)basePath, (Configuration)HoodieCLI.conf).globStatus(new Path(basePath + "/.hoodie/.commits_.archive*"));
        ArrayList<Comparable[]> allCommits = new ArrayList<Comparable[]>();
        for (FileStatus fs : fsStatuses) {
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((FileSystem)FSUtils.getFs((String)basePath, (Configuration)HoodieCLI.conf), (HoodieLogFile)new HoodieLogFile(fs.getPath()), (Schema)HoodieArchivedMetaEntry.getClassSchema());
            ArrayList readRecords = new ArrayList();
            while (reader.hasNext()) {
                HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                List records = blk.getRecords();
                readRecords.addAll(records);
            }
            List readCommits = readRecords.stream().map(r -> (GenericRecord)r).map(r -> this.readCommit((GenericRecord)r, skipMetadata)).collect(Collectors.toList());
            allCommits.addAll(readCommits);
            reader.close();
        }
        TableHeader header = new TableHeader().addTableHeaderField("CommitTime").addTableHeaderField("CommitType");
        if (!skipMetadata) {
            header = header.addTableHeaderField("CommitDetails");
        }
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, allCommits);
    }

    private Comparable[] readCommit(GenericRecord record, boolean skipMetadata) {
        ArrayList<Object> commitDetails = new ArrayList<Object>();
        try {
            switch (record.get("actionType").toString()) {
                case "clean": {
                    commitDetails.add(record.get("commitTime"));
                    commitDetails.add(record.get("actionType").toString());
                    if (!skipMetadata) {
                        commitDetails.add(record.get("hoodieCleanMetadata").toString());
                    }
                    break;
                }
                case "commit": {
                    commitDetails.add(record.get("commitTime"));
                    commitDetails.add(record.get("actionType").toString());
                    if (!skipMetadata) {
                        commitDetails.add(record.get("hoodieCommitMetadata").toString());
                    }
                    break;
                }
                case "deltacommit": {
                    commitDetails.add(record.get("commitTime"));
                    commitDetails.add(record.get("actionType").toString());
                    if (!skipMetadata) {
                        commitDetails.add(record.get("hoodieCommitMetadata").toString());
                    }
                    break;
                }
                case "rollback": {
                    commitDetails.add(record.get("commitTime"));
                    commitDetails.add(record.get("actionType").toString());
                    if (!skipMetadata) {
                        commitDetails.add(record.get("hoodieRollbackMetadata").toString());
                    }
                    break;
                }
                case "savepoint": {
                    commitDetails.add(record.get("commitTime"));
                    commitDetails.add(record.get("actionType").toString());
                    if (!skipMetadata) {
                        commitDetails.add(record.get("hoodieSavePointMetadata").toString());
                    }
                    break;
                }
                default: {
                    return commitDetails.toArray(new Comparable[commitDetails.size()]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return commitDetails.toArray(new Comparable[commitDetails.size()]);
    }
}

