/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.BloomFilter;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.HoodieParquetWriter;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;

public final class SparkHelpers$ {
    public static final SparkHelpers$ MODULE$;

    static {
        new SparkHelpers$();
    }

    public void skipKeysAndWriteNewFile(String commitTime, FileSystem fs, Path sourceFile, Path destinationFile, Set<String> keysToSkip) throws Exception {
        List sourceRecords = ParquetUtils.readAvroRecords((Configuration)fs.getConf(), (Path)sourceFile);
        Schema schema = ((GenericContainer)sourceRecords.get(0)).getSchema();
        BloomFilter filter = new BloomFilter(new StringOps(Predef$.MODULE$.augmentString("60000")).toInt(), new StringOps(Predef$.MODULE$.augmentString("0.000000001")).toDouble());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(schema), schema, filter);
        HoodieParquetConfig parquetConfig = new HoodieParquetConfig(writeSupport, CompressionCodecName.GZIP, new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.DEFAULT_PARQUET_BLOCK_SIZE_BYTES)).toInt(), new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.DEFAULT_PARQUET_PAGE_SIZE_BYTES)).toInt(), (long)new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.DEFAULT_PARQUET_FILE_MAX_BYTES)).toInt(), fs.getConf(), new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.DEFAULT_STREAM_COMPRESSION_RATIO)).toDouble());
        HoodieParquetWriter writer = new HoodieParquetWriter(commitTime, destinationFile, parquetConfig, schema);
        JavaConversions$.MODULE$.asScalaBuffer(sourceRecords).foreach((Function1)new Serializable(keysToSkip, writer){
            public static final long serialVersionUID = 0L;
            private final Set keysToSkip$1;
            private final HoodieParquetWriter writer$1;

            public final void apply(GenericRecord rec) {
                String key = rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                if (!this.keysToSkip$1.contains((Object)key)) {
                    this.writer$1.writeAvro(key, (IndexedRecord)rec);
                }
            }
            {
                this.keysToSkip$1 = keysToSkip$1;
                this.writer$1 = writer$1;
            }
        });
        writer.close();
    }

    private SparkHelpers$() {
        MODULE$ = this;
    }
}

