/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import org.apache.hudi.cli.HoodieCLI;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultPromptProvider;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class HoodiePrompt
extends DefaultPromptProvider {
    public String getPrompt() {
        if (HoodieCLI.tableMetadata != null) {
            String tableName = HoodieCLI.tableMetadata.getTableConfig().getTableName();
            switch (HoodieCLI.state) {
                case INIT: {
                    return "hudi->";
                }
                case DATASET: {
                    return "hudi:" + tableName + "->";
                }
                case SYNC: {
                    return "hudi:" + tableName + " <==> " + HoodieCLI.syncTableMetadata.getTableConfig().getTableName() + "->";
                }
            }
            return "hudi:" + tableName + "->";
        }
        return "hudi->";
    }

    public String getProviderName() {
        return "Hoodie provider";
    }
}

