/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ConsistencyGuardConfig;
import org.apache.hudi.common.util.FSUtils;

public class HoodieCLI {
    public static Configuration conf;
    public static ConsistencyGuardConfig consistencyGuardConfig;
    public static FileSystem fs;
    public static CLIState state;
    public static String basePath;
    public static HoodieTableMetaClient tableMetadata;
    public static HoodieTableMetaClient syncTableMetadata;

    public static void setConsistencyGuardConfig(ConsistencyGuardConfig config) {
        consistencyGuardConfig = config;
    }

    private static void setTableMetaClient(HoodieTableMetaClient tableMetadata) {
        HoodieCLI.tableMetadata = tableMetadata;
    }

    private static void setBasePath(String basePath) {
        HoodieCLI.basePath = basePath;
    }

    public static boolean initConf() {
        if (conf == null) {
            conf = FSUtils.prepareHadoopConf((Configuration)new Configuration());
            return true;
        }
        return false;
    }

    public static void initFS(boolean force) throws IOException {
        if (fs == null || force) {
            fs = tableMetadata != null ? tableMetadata.getFs() : FileSystem.get((Configuration)conf);
        }
    }

    public static void refreshTableMetadata() {
        HoodieCLI.setTableMetaClient(new HoodieTableMetaClient(conf, basePath, false, consistencyGuardConfig));
    }

    public static void connectTo(String basePath) {
        HoodieCLI.setBasePath(basePath);
        HoodieCLI.refreshTableMetadata();
    }

    static {
        consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
        state = CLIState.INIT;
    }

    public static enum CLIState {
        INIT,
        DATASET,
        SYNC;

    }
}

