/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.DedupeSparkJob$;
import org.apache.hudi.cli.SparkHelper;
import org.apache.hudi.cli.SparkHelpers$;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001-\u0011a\u0002R3ekB,7\u000b]1sW*{'M\u0003\u0002\u0004\t\u0005\u00191\r\\5\u000b\u0005\u00151\u0011\u0001\u00025vI&T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0005cCN,\u0007+\u0019;i!\t)\u0002D\u0004\u0002\u000e-%\u0011qCD\u0001\u0007!J,G-\u001a4\n\u0005eQ\"AB*ue&twM\u0003\u0002\u0018\u001d!AA\u0004\u0001B\u0001B\u0003%A#A\fekBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|g\u000eU1uQ\"Aa\u0004\u0001B\u0001B\u0003%A#\u0001\tsKB\f\u0017N](viB,H\u000fU1uQ\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011%\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'\r\u0005)1\u000f]1sW&\u0011\u0001f\t\u0002\u000b'Fc5i\u001c8uKb$\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0005\u0019\u001c\bC\u0001\u00171\u001b\u0005i#B\u0001\u0016/\u0015\tyc!\u0001\u0004iC\u0012|w\u000e]\u0005\u0003c5\u0012!BR5mKNK8\u000f^3n\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q1Qg\u000e\u001d:um\u0002\"A\u000e\u0001\u000e\u0003\tAQa\u0005\u001aA\u0002QAQ\u0001\b\u001aA\u0002QAQA\b\u001aA\u0002QAQ\u0001\t\u001aA\u0002\u0005BQA\u000b\u001aA\u0002-Bq!\u0010\u0001C\u0002\u0013\u0005a(A\u0006ta\u0006\u00148\u000eS3ma\u0016\u0014X#A \u0011\u0005Y\u0002\u0015BA!\u0003\u0005-\u0019\u0006/\u0019:l\u0011\u0016d\u0007/\u001a:\t\r\r\u0003\u0001\u0015!\u0003@\u00031\u0019\b/\u0019:l\u0011\u0016d\u0007/\u001a:!\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000b1\u0001T(H+\u00059\u0005C\u0001%L\u001b\u0005I%B\u0001&\u0007\u0003\u0015awn\u001a\u001bk\u0013\ta\u0015J\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u001d\u0002\u0001\u000b\u0011B$\u0002\t1{u\t\t\u0005\u0006!\u0002!\t!U\u0001\rO\u0016$H)\u001e9f\u0017\u0016LHI\u0012\u000b\u0003%\u0012\u0004\"aU1\u000f\u0005Q{fBA+_\u001d\t1VL\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!LC\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0002\u0005\n\u0005\u00192\u0011B\u0001\u0013&\u0013\t\u00017%A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'!\u0003#bi\u00064%/Y7f\u0015\t\u00017\u0005C\u0003f\u001f\u0002\u0007A#A\u0004uE2t\u0015-\\3\t\u000b\u001d\u0004A\u0011\u00025\u0002!Ad\u0017M\u001c#va2L7-\u0019;f\r&DH#A5\u0011\t)|G#]\u0007\u0002W*\u0011A.\\\u0001\b[V$\u0018M\u00197f\u0015\tqg\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001]6\u0003\u000f!\u000b7\u000f['baB\u0019!N\u001d\u000b\n\u0005M\\'a\u0002%bg\"\u001cV\r\u001e\u0005\u0006k\u0002!\tA^\u0001\u000eM&DH)\u001e9mS\u000e\fG/Z:\u0015\u0005]T\bCA\u0007y\u0013\tIhB\u0001\u0003V]&$\bbB>u!\u0003\u0005\r\u0001`\u0001\u0007IJL(+\u001e8\u0011\u00055i\u0018B\u0001@\u000f\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0001\u0001#\u0003%\t!a\u0001\u0002/\u0019L\u0007\u0010R;qY&\u001c\u0017\r^3tI\u0011,g-Y;mi\u0012\nTCAA\u0003U\ra\u0018qA\u0016\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0003\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0018\u00055!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DedupeSparkJob {
    public final String org$apache$hudi$cli$DedupeSparkJob$$basePath;
    public final String org$apache$hudi$cli$DedupeSparkJob$$duplicatedPartitionPath;
    public final String org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath;
    private final SQLContext sqlContext;
    public final FileSystem org$apache$hudi$cli$DedupeSparkJob$$fs;
    private final SparkHelper sparkHelper;
    private final Logger LOG;

    public SparkHelper sparkHelper() {
        return this.sparkHelper;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public Dataset<Row> getDupeKeyDF(String tblName) {
        String dupeSql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      select  `", "` as dupe_key,\n      count(*) as dupe_cnt\n      from ", "\n      group by `", "`\n      having dupe_cnt > 1\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieRecord.RECORD_KEY_METADATA_FIELD, tblName, HoodieRecord.RECORD_KEY_METADATA_FIELD}));
        return this.sqlContext.sql(dupeSql);
    }

    private HashMap<String, HashSet<String>> planDuplicateFix() {
        String tmpTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"htbl_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())}));
        String dedupeTblName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_dupeKeys"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpTableName}));
        HoodieTableMetaClient metadata = new HoodieTableMetaClient(this.org$apache$hudi$cli$DedupeSparkJob$$fs.getConf(), this.org$apache$hudi$cli$DedupeSparkJob$$basePath);
        FileStatus[] allFiles = this.org$apache$hudi$cli$DedupeSparkJob$$fs.listStatus(new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$hudi$cli$DedupeSparkJob$$basePath, this.org$apache$hudi$cli$DedupeSparkJob$$duplicatedPartitionPath}))));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), allFiles);
        java.util.List latestFiles = fsView.getLatestDataFiles().collect(Collectors.toList());
        Buffer filteredStatuses = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(latestFiles).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(HoodieDataFile f) {
                return f.getPath();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        this.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" List of files under partition: ", " =>  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxedUnit.UNIT, filteredStatuses.mkString(" ")})));
        Dataset df = this.sqlContext.parquetFile((Seq)filteredStatuses);
        df.registerTempTable(tmpTableName);
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF(tmpTableName);
        dupeKeyDF.registerTempTable(dedupeTblName);
        String dupeDataSql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        SELECT `_hoodie_record_key`, `_hoodie_partition_path`, `_hoodie_file_name`, `_hoodie_commit_time`\n        FROM ", " h\n        JOIN ", " d\n        ON h.`_hoodie_record_key` = d.dupe_key\n                      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpTableName, dedupeTblName}));
        Map dupeMap = JavaConversions$.MODULE$.asScalaBuffer(this.sqlContext.sql(dupeDataSql).collectAsList()).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row r) {
                return r.getString(0);
            }
        });
        HashMap fileToDeleteKeyMap = new HashMap();
        dupeMap.foreach((Function1)new Serializable(this, fileToDeleteKeyMap){
            public static final long serialVersionUID = 0L;
            public final HashMap fileToDeleteKeyMap$1;

            public final void apply(Tuple2<String, Buffer<Row>> rt) {
                Tuple2<String, Buffer<Row>> tuple2 = rt;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String key = (String)tuple2._1();
                    Buffer rows = (Buffer)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)key, (Object)rows);
                    String key2 = (String)tuple23._1();
                    Buffer rows2 = (Buffer)tuple23._2();
                    LongRef maxCommit = LongRef.create((long)-1L);
                    rows2.foreach((Function1)new Serializable(this, maxCommit){
                        public static final long serialVersionUID = 0L;
                        private final LongRef maxCommit$1;

                        public final void apply(Row r) {
                            long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                            if (c > this.maxCommit$1.elem) {
                                this.maxCommit$1.elem = c;
                            }
                        }
                        {
                            this.maxCommit$1 = maxCommit$1;
                        }
                    });
                    rows2.foreach((Function1)new Serializable(this, key2, maxCommit){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$planDuplicateFix$1 $outer;
                        private final String key$1;
                        private final LongRef maxCommit$1;

                        public final Object apply(Row r) {
                            Object object;
                            long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                            if (c != this.maxCommit$1.elem) {
                                String f = ((String)r.apply(2)).split("_")[0];
                                if (!this.$outer.fileToDeleteKeyMap$1.contains((Object)f)) {
                                    this.$outer.fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                                }
                                object = BoxesRunTime.boxToBoolean((boolean)((HashSet)this.$outer.fileToDeleteKeyMap$1.apply((Object)f)).add((Object)this.key$1));
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            return object;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                            this.maxCommit$1 = maxCommit$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fileToDeleteKeyMap$1 = fileToDeleteKeyMap$1;
            }
        });
        return fileToDeleteKeyMap;
    }

    public void fixDuplicates(boolean dryRun) {
        Dataset<Row> fixedDF;
        HoodieTableMetaClient metadata = new HoodieTableMetaClient(this.org$apache$hudi$cli$DedupeSparkJob$$fs.getConf(), this.org$apache$hudi$cli$DedupeSparkJob$$basePath);
        FileStatus[] allFiles = this.org$apache$hudi$cli$DedupeSparkJob$$fs.listStatus(new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$hudi$cli$DedupeSparkJob$$basePath, this.org$apache$hudi$cli$DedupeSparkJob$$duplicatedPartitionPath}))));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), allFiles);
        java.util.List latestFiles = fsView.getLatestDataFiles().collect(Collectors.toList());
        Map fileNameToPathMap = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(latestFiles).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Path> apply(HoodieDataFile f) {
                return new Tuple2((Object)f.getFileId(), (Object)new Path(f.getPath()));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        HashMap<String, HashSet<String>> dupeFixPlan = this.planDuplicateFix();
        fileNameToPathMap.foreach((Function1)new Serializable(this, dupeFixPlan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;
            private final HashMap dupeFixPlan$1;

            public final boolean apply(Tuple2<String, Path> x0$1) {
                Tuple2<String, Path> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    Path filePath = (Path)tuple2._2();
                    String badSuffix = this.dupeFixPlan$1.contains((Object)fileName) ? ".bad" : "";
                    Path dstPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath, filePath.getName(), badSuffix})));
                    this.$outer.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath, dstPath})));
                    boolean bl = FileUtil.copy((FileSystem)this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs, (Path)filePath, (FileSystem)this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs.getConf());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dupeFixPlan$1 = dupeFixPlan$1;
            }
        });
        dupeFixPlan.foreach((Function1)new Serializable(this, fileNameToPathMap, dupeFixPlan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;
            private final Map fileNameToPathMap$1;
            private final HashMap dupeFixPlan$1;

            public final boolean apply(Tuple2<String, HashSet<String>> x0$2) {
                Tuple2<String, HashSet<String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    String commitTime = FSUtils.getCommitTime((String)((Path)this.fileNameToPathMap$1.apply((Object)fileName)).getName());
                    Path badFilePath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".bad"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath, ((Path)this.fileNameToPathMap$1.apply((Object)fileName)).getName()})));
                    Path newFilePath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath, ((Path)this.fileNameToPathMap$1.apply((Object)fileName)).getName()})));
                    this.$outer.LOG().info((Object)new StringBuilder().append((Object)" Skipping and writing new file for : ").append((Object)fileName).toString());
                    SparkHelpers$.MODULE$.skipKeysAndWriteNewFile(commitTime, this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs, badFilePath, newFilePath, (Set<String>)((Set)this.dupeFixPlan$1.apply((Object)fileName)));
                    boolean bl = this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs.delete(badFilePath, false);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fileNameToPathMap$1 = fileNameToPathMap$1;
                this.dupeFixPlan$1 = dupeFixPlan$1;
            }
        });
        Dataset df = this.sqlContext.read().parquet(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/*.parquet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath})));
        df.registerTempTable("fixedTbl");
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF("fixedTbl");
        long dupeCnt = dupeKeyDF.count();
        if (dupeCnt != 0L) {
            dupeKeyDF.show();
            throw new HoodieException("Still found some duplicates!!.. Inspect output");
        }
        Dataset<Row> sourceDF = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Path> t) {
                return ((Path)t._2()).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList());
        Dataset missedRecordKeysDF = sourceDF.except(fixedDF = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;

            public final String apply(Tuple2<String, Path> t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath, ((Path)t._2()).getName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()));
        long missedCnt = missedRecordKeysDF.count();
        if (missedCnt != 0L) {
            missedRecordKeysDF.show();
            throw new HoodieException("Some records in source are not found in fixed files. Inspect output!!");
        }
        Predef$.MODULE$.println((Object)"No duplicates found & counts are in check!!!! ");
        fileNameToPathMap.foreach((Function1)new Serializable(this, dryRun){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;
            private final boolean dryRun$1;

            public final Object apply(Tuple2<String, Path> x0$3) {
                Tuple2<String, Path> tuple2 = x0$3;
                if (tuple2 != null) {
                    Object object;
                    Path filePath = (Path)tuple2._2();
                    Path srcPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath, filePath.getName()})));
                    Path dstPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$hudi$cli$DedupeSparkJob$$basePath, this.$outer.org$apache$hudi$cli$DedupeSparkJob$$duplicatedPartitionPath, filePath.getName()})));
                    if (this.dryRun$1) {
                        this.$outer.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[JUST KIDDING!!!] Copying from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, dstPath})));
                        object = BoxedUnit.UNIT;
                    } else {
                        this.$outer.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[FOR REAL!!!] Copying from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, dstPath})));
                        object = BoxesRunTime.boxToBoolean((boolean)FileUtil.copy((FileSystem)this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs, (Path)srcPath, (FileSystem)this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.$outer.org$apache$hudi$cli$DedupeSparkJob$$fs.getConf()));
                    }
                    BoxedUnit boxedUnit = object;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dryRun$1 = dryRun$1;
            }
        });
    }

    public boolean fixDuplicates$default$1() {
        return true;
    }

    public DedupeSparkJob(String basePath, String duplicatedPartitionPath, String repairOutputPath, SQLContext sqlContext, FileSystem fs) {
        this.org$apache$hudi$cli$DedupeSparkJob$$basePath = basePath;
        this.org$apache$hudi$cli$DedupeSparkJob$$duplicatedPartitionPath = duplicatedPartitionPath;
        this.org$apache$hudi$cli$DedupeSparkJob$$repairOutputPath = repairOutputPath;
        this.sqlContext = sqlContext;
        this.org$apache$hudi$cli$DedupeSparkJob$$fs = fs;
        this.sparkHelper = new SparkHelper(sqlContext, fs);
        this.LOG = Logger.getLogger(this.getClass());
    }
}

