/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.URIBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestURIUtils {
    private final URI baseURI = URI.create("http://a/b/c/d;p?q");

    @Test
    public void testResolve() {
        Assertions.assertEquals((Object)"g:h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g:h").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/").toString());
        Assertions.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/g").toString());
        Assertions.assertEquals((Object)"http://g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"//g").toString());
        Assertions.assertEquals((Object)"http://a/b/c/d;p?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y").toString());
        Assertions.assertEquals((Object)"http://a/b/c/d;p?y#f", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y#f").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y").toString());
        Assertions.assertEquals((Object)"http://a/b/c/d;p?q#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"#s").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y#s").toString());
        Assertions.assertEquals((Object)"http://a/b/c/;x", (Object)URIUtils.resolve((URI)this.baseURI, (String)";x").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g;x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g;x?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x?y#s").toString());
        Assertions.assertEquals((Object)"http://a/b/c/d;p?q", (Object)URIUtils.resolve((URI)this.baseURI, (String)"").toString());
        Assertions.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)".").toString());
        Assertions.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./").toString());
        Assertions.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..").toString());
        Assertions.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../").toString());
        Assertions.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../g").toString());
        Assertions.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../..").toString());
        Assertions.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../").toString());
        Assertions.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../g").toString());
        Assertions.assertEquals((Object)"http://a/../g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../g").toString());
        Assertions.assertEquals((Object)"http://a/../../g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../../g").toString());
        Assertions.assertEquals((Object)"http://a/./g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/./g").toString());
        Assertions.assertEquals((Object)"http://a/../g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/../g").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g.", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g.").toString());
        Assertions.assertEquals((Object)"http://a/b/c/.g", (Object)URIUtils.resolve((URI)this.baseURI, (String)".g").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g..", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g..").toString());
        Assertions.assertEquals((Object)"http://a/b/c/..g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..g").toString());
        Assertions.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./../g").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g/.").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/./h").toString());
        Assertions.assertEquals((Object)"http://a/b/c/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/../h").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g;x=1/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/./y").toString());
        Assertions.assertEquals((Object)"http://a/b/c/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/../y").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g?y/./x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/./x").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g?y/../x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/../x").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g#s/./x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/./x").toString());
        Assertions.assertEquals((Object)"http://a/b/c/g#s/../x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/../x").toString());
        Assertions.assertEquals((Object)"http:g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http:g").toString());
        Assertions.assertEquals((Object)"http://s/a/b/c/./../../g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/a/b/c/./../../g").toString());
        Assertions.assertEquals((Object)"http://s/mid/content=5/../6", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/mid/content=5/../6").toString());
    }

    @Test
    public void testResolveOpaque() {
        Assertions.assertEquals((Object)"example://a/./b/../b/%63/%7bfoo%7d", (Object)URIUtils.resolve((URI)this.baseURI, (String)"eXAMPLE://a/./b/../b/%63/%7bfoo%7d").toString());
        Assertions.assertEquals((Object)"file://localhost/etc/fstab", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file://localhost/etc/fstab").toString());
        Assertions.assertEquals((Object)"file:///etc/fstab", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file:///etc/fstab").toString());
        Assertions.assertEquals((Object)"file://localhost/c:/WINDOWS/clock.avi", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file://localhost/c:/WINDOWS/clock.avi").toString());
        Assertions.assertEquals((Object)"file:///c:/WINDOWS/clock.avi", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file:///c:/WINDOWS/clock.avi").toString());
        Assertions.assertEquals((Object)"file://hostname/path/to/the%20file.txt", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file://hostname/path/to/the%20file.txt").toString());
        Assertions.assertEquals((Object)"file:///c:/path/to/the%20file.txt", (Object)URIUtils.resolve((URI)this.baseURI, (String)"file:///c:/path/to/the%20file.txt").toString());
        Assertions.assertEquals((Object)"urn:issn:1535-3613", (Object)URIUtils.resolve((URI)this.baseURI, (String)"urn:issn:1535-3613").toString());
        Assertions.assertEquals((Object)"mailto:user@example.com", (Object)URIUtils.resolve((URI)this.baseURI, (String)"mailto:user@example.com").toString());
        Assertions.assertEquals((Object)"ftp://example.org/resource.txt", (Object)URIUtils.resolve((URI)this.baseURI, (String)"ftp://example.org/resource.txt").toString());
    }

    @Test
    public void testExtractHost() throws Exception {
        Assertions.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd")));
        Assertions.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd%3A")));
        Assertions.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd")));
        Assertions.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd%3A")));
        Assertions.assertEquals((Object)new HttpHost("localhost", 8), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8/abcd")));
        Assertions.assertEquals((Object)new HttpHost("local_host", 8), (Object)URIUtils.extractHost((URI)new URI("http://local_host:8/abcd")));
        Assertions.assertEquals((Object)new HttpHost("localhost", -1), (Object)URIUtils.extractHost((URI)new URI("http://localhost:/abcd")));
        Assertions.assertEquals((Object)new HttpHost("local_host", -1), (Object)URIUtils.extractHost((URI)new URI("http://local_host:/abcd")));
        Assertions.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@localhost:8080/abcd")));
        Assertions.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@local_host:8080/abcd")));
        Assertions.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@localhost:8080/abcd")));
        Assertions.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@local_host:8080/abcd")));
        Assertions.assertEquals((Object)new HttpHost("2a00:1450:400c:c01::69", 8080), (Object)URIUtils.extractHost((URI)new URI("http://[2a00:1450:400c:c01::69]:8080/")));
        Assertions.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8080/;sessionid=stuff/abcd")));
        Assertions.assertNull((Object)URIUtils.extractHost((URI)new URI("http://localhost:8080;sessionid=stuff/abcd")));
        Assertions.assertNull((Object)URIUtils.extractHost((URI)new URI("http://localhost:;sessionid=stuff/abcd")));
        Assertions.assertNull((Object)URIUtils.extractHost((URI)new URI("http://:80/robots.txt")));
        Assertions.assertNull((Object)URIUtils.extractHost((URI)new URI("http://some%20domain:80/robots.txt")));
    }

    @Test
    public void testHttpLocationWithRelativeFragment() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", -1);
        URI requestURI = new URI("/stuff#blahblah");
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, null);
        URI expectedURI = new URIBuilder(requestURI).setHost(target.getHostName()).setScheme(target.getSchemeName()).build();
        Assertions.assertEquals((Object)expectedURI, (Object)location);
    }

    @Test
    public void testHttpLocationWithAbsoluteFragment() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", 80);
        URI requestURI = new URIBuilder().setHost(target.getHostName()).setScheme(target.getSchemeName()).setPath("/stuff").setFragment("blahblah").build();
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, null);
        URI expectedURI = requestURI;
        Assertions.assertEquals((Object)expectedURI, (Object)location);
    }

    @Test
    public void testHttpLocationRedirect() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", -1);
        URI requestURI = new URI("/People.htm#tim");
        URI redirect = new URI("http://localhost/people.html");
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, Collections.singletonList(redirect));
        URI expectedURI = new URIBuilder().setHost(target.getHostName()).setScheme(target.getSchemeName()).setPath("/people.html").setFragment("tim").build();
        Assertions.assertEquals((Object)expectedURI, (Object)location);
    }

    @Test
    public void testHttpLocationWithRedirectFragment() throws Exception {
        HttpHost target = new HttpHost("http", "localhost", -1);
        URI requestURI = new URI("/~tim");
        URI redirect1 = new URI("http://localhost/People.htm#tim");
        URI redirect2 = new URI("http://localhost/people.html");
        URI location = URIUtils.resolve((URI)requestURI, (HttpHost)target, Arrays.asList(redirect1, redirect2));
        URI expectedURI = new URIBuilder().setHost(target.getHostName()).setScheme(target.getSchemeName()).setPath("/people.html").setFragment("tim").build();
        Assertions.assertEquals((Object)expectedURI, (Object)location);
    }
}

