/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.utils.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBase64 {
    public static final char CHAR_ZERO = '\u0000';
    public static final String EMPTY_STR = "";
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final String NULL_STR = null;
    public static final byte[] NULL_BYTE_ARRAY = null;
    public static final String EMOJI = "\ud83d\ude15";
    public static final char SPACE = ' ';
    private final Base64 target = new Base64();

    @Test
    void nullHandling() {
        Assertions.assertNull((Object)this.target.decode(NULL_STR));
        Assertions.assertNull((Object)this.target.decode(NULL_BYTE_ARRAY));
        Assertions.assertNull((Object)Base64.decodeBase64((String)NULL_STR));
        Assertions.assertNull((Object)Base64.decodeBase64((byte[])NULL_BYTE_ARRAY));
        Assertions.assertNull((Object)this.target.encode(NULL_BYTE_ARRAY));
        Assertions.assertNull((Object)Base64.encodeBase64((byte[])NULL_BYTE_ARRAY));
        Assertions.assertNull((Object)Base64.encodeBase64String((byte[])NULL_BYTE_ARRAY));
    }

    @Test
    void zeroLength() {
        Assertions.assertArrayEquals((byte[])EMPTY_BYTES, (byte[])this.target.decode(EMPTY_STR));
        Assertions.assertArrayEquals((byte[])EMPTY_BYTES, (byte[])this.target.decode(EMPTY_BYTES));
        Assertions.assertArrayEquals((byte[])EMPTY_BYTES, (byte[])Base64.decodeBase64((String)EMPTY_STR));
        Assertions.assertArrayEquals((byte[])EMPTY_BYTES, (byte[])Base64.decodeBase64((byte[])EMPTY_BYTES));
        Assertions.assertArrayEquals((byte[])EMPTY_BYTES, (byte[])this.target.encode(EMPTY_BYTES));
        Assertions.assertArrayEquals((byte[])EMPTY_BYTES, (byte[])Base64.encodeBase64((byte[])EMPTY_BYTES));
        Assertions.assertEquals((Object)EMPTY_STR, (Object)Base64.encodeBase64String((byte[])EMPTY_BYTES));
    }

    @Test
    void validValues() {
        byte[] unencodedBytes = "Hello World!".getBytes(StandardCharsets.US_ASCII);
        this.checkDecode(unencodedBytes, "SGVsbG8gV29ybGQh");
        this.checkEncode("SGVsbG8gV29ybGQh", unencodedBytes);
    }

    @Test
    void decodeIgnoresEmbeddedInvalidChars() {
        this.checkEquivalentDecode(TestBase64.fourOf("A"), " A A A A ");
        this.checkEquivalentDecode(TestBase64.fourOf("A"), "AA\ud83d\ude15AA");
    }

    @Test
    void decodeInvalid() {
        this.checkDecode(EMPTY_BYTES, TestBase64.fourOf(EMOJI));
        this.checkDecode(EMPTY_BYTES, "A");
        this.checkDecode(EMPTY_BYTES, "A===");
        this.checkDecode(EMPTY_BYTES, TestBase64.fourOf(' '));
        this.checkDecode(EMPTY_BYTES, TestBase64.fourOf('='));
        this.checkDecode(EMPTY_BYTES, TestBase64.fourOf('@'));
        this.checkDecode(EMPTY_BYTES, TestBase64.fourOf('\u0000'));
    }

    @Test
    void decodeUnpadded() {
        this.checkEquivalentDecode("AA==", "AA");
    }

    private void checkDecode(byte[] expectedDecoded, String testInput) {
        byte[] decoded = this.target.decode(testInput);
        Assertions.assertArrayEquals((byte[])expectedDecoded, (byte[])decoded);
    }

    private void checkEncode(String expectedEncoded, byte[] testInput) {
        byte[] encoded = this.target.encode(testInput);
        Assertions.assertEquals((Object)expectedEncoded, (Object)new String(encoded, StandardCharsets.US_ASCII));
    }

    private void checkEquivalentDecode(String expectedEquivalentTo, String testInput) {
        byte[] decoded = this.target.decode(testInput);
        byte[] expectedDecoded = java.util.Base64.getDecoder().decode(expectedEquivalentTo);
        Assertions.assertArrayEquals((byte[])expectedDecoded, (byte[])decoded);
    }

    private static String fourOf(char c) {
        String charStr = String.valueOf(c);
        return TestBase64.fourOf(charStr);
    }

    private static String fourOf(String str) {
        return str + str + str + str;
    }
}

