/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.util.List;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.cookie.RFC6265LaxSpec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.ResponseProcessCookies;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestResponseProcessCookies {
    private CookieOrigin cookieOrigin;
    private CookieSpec cookieSpec;
    private CookieStore cookieStore;

    @BeforeEach
    public void setUp() throws Exception {
        this.cookieOrigin = new CookieOrigin("localhost", 80, "/", false);
        this.cookieSpec = new RFC6265LaxSpec();
        this.cookieStore = new BasicCookieStore();
    }

    @Test
    public void testResponseParameterCheck() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        ResponseProcessCookies interceptor = ResponseProcessCookies.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> TestResponseProcessCookies.lambda$testResponseParameterCheck$0((HttpResponseInterceptor)interceptor, context));
    }

    @Test
    public void testContextParameterCheck() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        ResponseProcessCookies interceptor = ResponseProcessCookies.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> TestResponseProcessCookies.lambda$testContextParameterCheck$1((HttpResponseInterceptor)interceptor, (HttpResponse)response));
    }

    @Test
    public void testParseCookies() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setCookieOrigin(this.cookieOrigin);
        context.setCookieSpec(this.cookieSpec);
        context.setCookieStore(this.cookieStore);
        ResponseProcessCookies interceptor = ResponseProcessCookies.INSTANCE;
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assertions.assertNotNull((Object)cookies);
        Assertions.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assertions.assertEquals((Object)"name1", (Object)cookie.getName());
        Assertions.assertEquals((Object)"value1", (Object)cookie.getValue());
        Assertions.assertEquals((Object)"localhost", (Object)cookie.getDomain());
        Assertions.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testNoCookieOrigin() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setCookieOrigin(null);
        context.setCookieSpec(this.cookieSpec);
        context.setCookieStore(this.cookieStore);
        ResponseProcessCookies interceptor = ResponseProcessCookies.INSTANCE;
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assertions.assertNotNull((Object)cookies);
        Assertions.assertEquals((int)0, (int)cookies.size());
    }

    @Test
    public void testNoCookieSpec() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setCookieOrigin(this.cookieOrigin);
        context.setCookieSpec(null);
        context.setCookieStore(this.cookieStore);
        ResponseProcessCookies interceptor = ResponseProcessCookies.INSTANCE;
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assertions.assertNotNull((Object)cookies);
        Assertions.assertEquals((int)0, (int)cookies.size());
    }

    @Test
    public void testNoCookieStore() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Set-Cookie", (Object)"name1=value1");
        HttpClientContext context = HttpClientContext.create();
        context.setCookieOrigin(this.cookieOrigin);
        context.setCookieSpec(this.cookieSpec);
        context.setCookieStore(null);
        ResponseProcessCookies interceptor = ResponseProcessCookies.INSTANCE;
        interceptor.process((HttpResponse)response, null, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assertions.assertNotNull((Object)cookies);
        Assertions.assertEquals((int)0, (int)cookies.size());
    }

    private static /* synthetic */ void lambda$testContextParameterCheck$1(HttpResponseInterceptor interceptor, HttpResponse response) throws Throwable {
        interceptor.process(response, null, null);
    }

    private static /* synthetic */ void lambda$testResponseParameterCheck$0(HttpResponseInterceptor interceptor, HttpClientContext context) throws Throwable {
        interceptor.process(null, null, (HttpContext)context);
    }
}

