/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import org.apache.hc.client5.http.protocol.RequestIfRange;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;

class TestRequestIfRange {
    @Mock
    private HttpRequest request;
    @Mock
    private EntityDetails entity;
    @Mock
    private HttpContext context;
    private RequestIfRange requestIfRange;

    TestRequestIfRange() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.requestIfRange = new RequestIfRange();
    }

    @Test
    void testNoIfRangeHeader() throws Exception {
        Mockito.when((Object)this.request.getFirstHeader("If-Range")).thenReturn(null);
        this.requestIfRange.process(this.request, this.entity, this.context);
    }

    @Test
    void testIfRangeWithoutRangeHeader() {
        Mockito.when((Object)this.request.getFirstHeader("If-Range")).thenReturn(Mockito.mock(Header.class));
        Mockito.when((Object)this.request.containsHeader("Range")).thenReturn((Object)false);
        Assertions.assertThrows(ProtocolException.class, () -> this.requestIfRange.process(this.request, this.entity, this.context));
    }

    @Test
    void testWeakETagInIfRange() {
        Mockito.when((Object)this.request.getFirstHeader("If-Range")).thenReturn(Mockito.mock(Header.class));
        Mockito.when((Object)this.request.containsHeader("Range")).thenReturn((Object)true);
        Mockito.when((Object)this.request.getFirstHeader("ETag")).thenReturn(Mockito.mock(Header.class, (Answer)Answers.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.request.getFirstHeader("ETag").getValue()).thenReturn((Object)"W/\"weak-etag\"");
        Assertions.assertThrows(ProtocolException.class, () -> this.requestIfRange.process(this.request, this.entity, this.context));
    }

    @Test
    void testDateHeaderWithStrongValidator() throws Exception {
        Mockito.when((Object)this.request.getFirstHeader("If-Range")).thenReturn(Mockito.mock(Header.class));
        Mockito.when((Object)this.request.containsHeader("Range")).thenReturn((Object)true);
        Mockito.when((Object)this.request.getFirstHeader("Date")).thenReturn(Mockito.mock(Header.class, (Answer)Answers.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.request.getFirstHeader("Date").getValue()).thenReturn((Object)"Tue, 15 Nov 2022 08:12:31 GMT");
        Mockito.when((Object)this.request.getFirstHeader("Last-Modified")).thenReturn(Mockito.mock(Header.class, (Answer)Answers.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.request.getFirstHeader("Last-Modified").getValue()).thenReturn((Object)"Tue, 15 Nov 2022 08:12:30 GMT");
        this.requestIfRange.process(this.request, this.entity, this.context);
    }

    @Test
    void testSmallDifferenceWithETagPresent() {
        Mockito.when((Object)this.request.getFirstHeader("If-Range")).thenReturn(Mockito.mock(Header.class));
        Mockito.when((Object)this.request.containsHeader("Range")).thenReturn((Object)true);
        Mockito.when((Object)this.request.getFirstHeader("Date")).thenReturn(Mockito.mock(Header.class, (Answer)Answers.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.request.getFirstHeader("Date").getValue()).thenReturn((Object)"Tue, 15 Nov 2022 08:12:30 GMT");
        Mockito.when((Object)this.request.getFirstHeader("Last-Modified")).thenReturn(Mockito.mock(Header.class, (Answer)Answers.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.request.getFirstHeader("Last-Modified").getValue()).thenReturn((Object)"Tue, 15 Nov 2022 08:12:30 GMT");
        Header mockETagHeader = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)mockETagHeader.getValue()).thenReturn((Object)"\"some-value\"");
        Mockito.when((Object)this.request.getFirstHeader("ETag")).thenReturn((Object)mockETagHeader);
        Assertions.assertThrows(ProtocolException.class, () -> this.requestIfRange.process(this.request, this.entity, this.context));
    }

    @Test
    void testSmallDifferenceWithETagAbsent() throws Exception {
        Mockito.when((Object)this.request.getFirstHeader("If-Range")).thenReturn(Mockito.mock(Header.class));
        Mockito.when((Object)this.request.containsHeader("Range")).thenReturn((Object)true);
        Mockito.when((Object)this.request.getFirstHeader("Date")).thenReturn(Mockito.mock(Header.class, (Answer)Answers.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.request.getFirstHeader("Date").getValue()).thenReturn((Object)"Tue, 15 Nov 2022 08:12:31 GMT");
        Mockito.when((Object)this.request.getFirstHeader("Last-Modified")).thenReturn(Mockito.mock(Header.class, (Answer)Answers.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.request.getFirstHeader("Last-Modified").getValue()).thenReturn((Object)"Tue, 15 Nov 2022 08:12:30 GMT");
        Mockito.when((Object)this.request.getFirstHeader("ETag")).thenReturn(null);
        this.requestIfRange.process(this.request, this.entity, this.context);
    }
}

