/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.net.InetAddress;
import java.net.URI;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.net.URIAuthority;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRoutingSupport {
    @Test
    public void testDetermineHost() throws Exception {
        BasicHttpRequest request1 = new BasicHttpRequest("GET", "/");
        HttpHost host1 = RoutingSupport.determineHost((HttpRequest)request1);
        MatcherAssert.assertThat((Object)host1, (Matcher)CoreMatchers.nullValue());
        BasicHttpRequest request2 = new BasicHttpRequest("GET", new URI("https://somehost:8443/"));
        HttpHost host2 = RoutingSupport.determineHost((HttpRequest)request2);
        MatcherAssert.assertThat((Object)host2, (Matcher)CoreMatchers.equalTo((Object)new HttpHost("https", "somehost", 8443)));
    }

    @Test
    public void testDetermineHostMissingScheme() throws Exception {
        BasicHttpRequest request1 = new BasicHttpRequest("GET", "/");
        request1.setAuthority(new URIAuthority("host"));
        Assertions.assertThrows(ProtocolException.class, () -> TestRoutingSupport.lambda$testDetermineHostMissingScheme$0((HttpRequest)request1));
    }

    @Test
    public void testNormalizeHost() throws Exception {
        Assertions.assertEquals((Object)new HttpHost("http", "somehost", 80), (Object)RoutingSupport.normalize((HttpHost)new HttpHost("http", "somehost", -1), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE));
        Assertions.assertEquals((Object)new HttpHost("https", "somehost", 443), (Object)RoutingSupport.normalize((HttpHost)new HttpHost("https", "somehost", -1), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE));
        Assertions.assertEquals((Object)new HttpHost("http", InetAddress.getLocalHost(), "localhost", 80), (Object)RoutingSupport.normalize((HttpHost)new HttpHost("http", InetAddress.getLocalHost(), "localhost", -1), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE));
        Assertions.assertEquals((Object)new HttpHost("http", "somehost", 8080), (Object)RoutingSupport.normalize((HttpHost)new HttpHost("http", "somehost", 8080), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE));
    }

    private static /* synthetic */ void lambda$testDetermineHostMissingScheme$0(HttpRequest request1) throws Throwable {
        RoutingSupport.determineHost((HttpRequest)request1);
    }
}

