/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDefaultRoutePlanner {
    private SchemePortResolver schemePortResolver;
    private DefaultRoutePlanner routePlanner;

    @BeforeEach
    public void setup() {
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.routePlanner = new DefaultRoutePlanner(this.schemePortResolver);
    }

    @Test
    public void testDirect() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        HttpClientContext context = HttpClientContext.create();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assertions.assertEquals((Object)target, (Object)route.getTargetHost());
        Assertions.assertEquals((int)1, (int)route.getHopCount());
        Assertions.assertFalse((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)Mockito.any());
    }

    @Test
    public void testDirectDefaultPort() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", -1);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)443);
        HttpClientContext context = HttpClientContext.create();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assertions.assertEquals((Object)new HttpHost("https", "somehost", 443), (Object)route.getTargetHost());
        Assertions.assertEquals((int)1, (int)route.getHopCount());
        Assertions.assertTrue((boolean)route.isSecure());
    }

    @Test
    public void testViaProxy() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        HttpHost proxy = new HttpHost("proxy", 8080);
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setProxy(proxy).build());
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assertions.assertEquals((Object)target, (Object)route.getTargetHost());
        Assertions.assertEquals((Object)proxy, (Object)route.getProxyHost());
        Assertions.assertEquals((int)2, (int)route.getHopCount());
        Assertions.assertFalse((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)Mockito.any());
    }

    @Test
    public void testNullTarget() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testNullTarget$0((HttpContext)context));
    }

    @Test
    public void testVirtualSecureHost() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        URIAuthority virtualHost = new URIAuthority("someotherhost", 443);
        BasicHttpRequest request = new BasicHttpRequest("https", "GET", virtualHost, "/");
        HttpClientContext context = HttpClientContext.create();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assertions.assertEquals((Object)target, (Object)route.getTargetHost());
        Assertions.assertEquals((Object)virtualHost, (Object)route.getTargetName());
        Assertions.assertEquals((int)1, (int)route.getHopCount());
        Assertions.assertTrue((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)Mockito.any());
    }

    @Test
    public void testVirtualInsecureHost() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        URIAuthority virtualHost = new URIAuthority("someotherhost", 80);
        BasicHttpRequest request = new BasicHttpRequest("http", "GET", virtualHost, "/");
        HttpClientContext context = HttpClientContext.create();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assertions.assertEquals((Object)target, (Object)route.getTargetHost());
        Assertions.assertNull((Object)route.getTargetName());
        Assertions.assertEquals((int)1, (int)route.getHopCount());
        Assertions.assertFalse((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)Mockito.any());
    }

    private /* synthetic */ void lambda$testNullTarget$0(HttpContext context) throws Throwable {
        this.routePlanner.determineRoute(null, context);
    }
}

