/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.client5.http.CircularRedirectException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RedirectException;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.RedirectExec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.io.support.ClassicResponseBuilder;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestRedirectExec {
    @Mock
    private HttpRoutePlanner httpRoutePlanner;
    @Mock
    private ExecChain chain;
    @Mock
    private ExecRuntime endpoint;
    private RedirectStrategy redirectStrategy;
    private RedirectExec redirectExec;
    private HttpHost target;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        this.target = new HttpHost("localhost", 80);
        this.redirectStrategy = (RedirectStrategy)Mockito.spy((Object)new DefaultRedirectStrategy());
        this.redirectExec = new RedirectExec(this.httpRoutePlanner, this.redirectStrategy);
    }

    @Test
    public void testFundamentals() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response1 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(302));
        URI redirect = new URI("http://localhost:80/redirect");
        response1.setHeader("Location", (Object)redirect.toASCIIString());
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        HttpEntity entity1 = EntityBuilder.create().setStream(inStream1).build();
        response1.setEntity(entity1);
        ClassicHttpResponse response2 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(200));
        InputStream inStream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        HttpEntity entity2 = EntityBuilder.create().setStream(inStream2).build();
        response2.setEntity(entity2);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)ArgumentMatchers.same((Object)request), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(redirect), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response2);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ArgumentCaptor reqCaptor = ArgumentCaptor.forClass(ClassicHttpRequest.class);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)reqCaptor.capture(), (ExecChain.Scope)ArgumentMatchers.same((Object)scope));
        List allValues = reqCaptor.getAllValues();
        Assertions.assertNotNull((Object)allValues);
        Assertions.assertEquals((int)2, (int)allValues.size());
        Assertions.assertSame((Object)request, allValues.get(0));
        ((ClassicHttpResponse)Mockito.verify((Object)response1, (VerificationMode)Mockito.times((int)1))).close();
        ((InputStream)Mockito.verify((Object)inStream1, (VerificationMode)Mockito.times((int)2))).close();
        ((ClassicHttpResponse)Mockito.verify((Object)response2, (VerificationMode)Mockito.never())).close();
        ((InputStream)Mockito.verify((Object)inStream2, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testMaxRedirect() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(true).setMaxRedirects(3).build();
        context.setRequestConfig(config);
        ClassicHttpResponse response1 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(302));
        URI redirect = new URI("http://localhost:80/redirect");
        response1.setHeader("Location", (Object)redirect.toASCIIString());
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)ArgumentMatchers.any(), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        Assertions.assertThrows(RedirectException.class, () -> this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain));
    }

    @Test
    public void testRelativeRedirect() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response1 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(302));
        URI redirect = new URI("/redirect");
        response1.setHeader("Location", (Object)redirect.toASCIIString());
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)ArgumentMatchers.same((Object)request), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        Assertions.assertThrows(HttpException.class, () -> this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain));
    }

    @Test
    public void testCrossSiteRedirect() throws Exception {
        HttpHost proxy = new HttpHost("proxy");
        HttpRoute route = new HttpRoute(this.target, proxy);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        AuthExchange targetAuthExchange = new AuthExchange();
        targetAuthExchange.setState(AuthExchange.State.SUCCESS);
        targetAuthExchange.select((AuthScheme)new BasicScheme());
        AuthExchange proxyAuthExchange = new AuthExchange();
        proxyAuthExchange.setState(AuthExchange.State.SUCCESS);
        proxyAuthExchange.select((AuthScheme)new BasicScheme(){

            public boolean isConnectionBased() {
                return true;
            }
        });
        context.setAuthExchange(this.target, targetAuthExchange);
        context.setAuthExchange(proxy, proxyAuthExchange);
        ClassicHttpResponse response1 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(302));
        URI redirect = new URI("http://otherhost:8888/redirect");
        response1.setHeader("Location", (Object)redirect.toASCIIString());
        ClassicHttpResponse response2 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(200));
        HttpHost otherHost = new HttpHost("otherhost", 8888);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)ArgumentMatchers.same((Object)request), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(redirect), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response2);
        Mockito.when((Object)this.httpRoutePlanner.determineRoute((HttpHost)ArgumentMatchers.eq((Object)otherHost), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)new HttpRoute(otherHost));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain);
        AuthExchange authExchange1 = context.getAuthExchange(this.target);
        Assertions.assertNotNull((Object)authExchange1);
        Assertions.assertEquals((Object)AuthExchange.State.UNCHALLENGED, (Object)authExchange1.getState());
        Assertions.assertNull((Object)authExchange1.getAuthScheme());
        AuthExchange authExchange2 = context.getAuthExchange(proxy);
        Assertions.assertNotNull((Object)authExchange2);
        Assertions.assertEquals((Object)AuthExchange.State.UNCHALLENGED, (Object)authExchange2.getState());
        Assertions.assertNull((Object)authExchange2.getAuthScheme());
    }

    @Test
    public void testAllowCircularRedirects() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setCircularRedirectsAllowed(true).build());
        URI uri = URI.create("http://localhost/");
        HttpGet request = new HttpGet(uri);
        URI uri1 = URI.create("http://localhost/stuff1");
        URI uri2 = URI.create("http://localhost/stuff2");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(302);
        response1.addHeader("Location", (Object)uri1.toASCIIString());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(302);
        response2.addHeader("Location", (Object)uri2.toASCIIString());
        BasicClassicHttpResponse response3 = new BasicClassicHttpResponse(302);
        response3.addHeader("Location", (Object)uri1.toASCIIString());
        BasicClassicHttpResponse response4 = new BasicClassicHttpResponse(200);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(uri), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(uri1), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response2, (Object[])new ClassicHttpResponse[]{response4});
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(uri2), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response3);
        Mockito.when((Object)this.httpRoutePlanner.determineRoute((HttpHost)ArgumentMatchers.eq((Object)new HttpHost("localhost")), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)route);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain);
        RedirectLocations uris = context.getRedirectLocations();
        Assertions.assertNotNull((Object)uris);
        Assertions.assertEquals(Arrays.asList(uri1, uri2, uri1), (Object)uris.getAll());
    }

    @Test
    public void testGetLocationUriDisallowCircularRedirects() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setCircularRedirectsAllowed(false).build());
        URI uri = URI.create("http://localhost/");
        HttpGet request = new HttpGet(uri);
        URI uri1 = URI.create("http://localhost/stuff1");
        URI uri2 = URI.create("http://localhost/stuff2");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(302);
        response1.addHeader("Location", (Object)uri1.toASCIIString());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(302);
        response2.addHeader("Location", (Object)uri2.toASCIIString());
        BasicClassicHttpResponse response3 = new BasicClassicHttpResponse(302);
        response3.addHeader("Location", (Object)uri1.toASCIIString());
        Mockito.when((Object)this.httpRoutePlanner.determineRoute((HttpHost)ArgumentMatchers.eq((Object)new HttpHost("localhost")), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)route);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(uri), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(uri1), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response2);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(uri2), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response3);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        Assertions.assertThrows(CircularRedirectException.class, () -> this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain));
    }

    @Test
    public void testRedirectRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response1 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(302));
        URI redirect = new URI("http://localhost:80/redirect");
        response1.setHeader("Location", (Object)redirect.toASCIIString());
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)ArgumentMatchers.same((Object)request), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        ((RedirectStrategy)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Oppsie")}).when((Object)this.redirectStrategy)).getLocationURI((HttpRequest)ArgumentMatchers.any(), (HttpResponse)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        Assertions.assertThrows(RuntimeException.class, () -> this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain));
        ((ClassicHttpResponse)Mockito.verify((Object)response1)).close();
    }

    @Test
    public void testRedirectProtocolException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response1 = (ClassicHttpResponse)Mockito.spy((Object)new BasicClassicHttpResponse(302));
        URI redirect = new URI("http://localhost:80/redirect");
        response1.setHeader("Location", (Object)redirect.toASCIIString());
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        HttpEntity entity1 = EntityBuilder.create().setStream(inStream1).build();
        response1.setEntity(entity1);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)ArgumentMatchers.same((Object)request), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        ((RedirectStrategy)Mockito.doThrow((Throwable[])new Throwable[]{new ProtocolException("Oppsie")}).when((Object)this.redirectStrategy)).getLocationURI((HttpRequest)ArgumentMatchers.any(), (HttpResponse)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        Assertions.assertThrows(ProtocolException.class, () -> this.redirectExec.execute((ClassicHttpRequest)request, scope, this.chain));
        ((InputStream)Mockito.verify((Object)inStream1, (VerificationMode)Mockito.times((int)2))).close();
        ((ClassicHttpResponse)Mockito.verify((Object)response1)).close();
    }

    @Test
    public void testPutSeeOtherRedirect() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        URI targetUri = new URI("http://localhost:80/stuff");
        ClassicHttpRequest request = ClassicRequestBuilder.put().setUri(targetUri).setEntity("stuff").build();
        HttpClientContext context = HttpClientContext.create();
        URI redirect1 = new URI("http://localhost:80/see-something-else");
        ClassicHttpResponse response1 = ClassicResponseBuilder.create((int)303).addHeader("Location", redirect1.toASCIIString()).build();
        URI redirect2 = new URI("http://localhost:80/other-stuff");
        ClassicHttpResponse response2 = ClassicResponseBuilder.create((int)301).addHeader("Location", redirect2.toASCIIString()).build();
        ClassicHttpResponse response3 = ClassicResponseBuilder.create((int)200).build();
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(targetUri), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(redirect1), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response2);
        Mockito.when((Object)this.chain.proceed(HttpRequestMatcher.matchesRequestUri(redirect2), (ExecChain.Scope)ArgumentMatchers.any())).thenReturn((Object)response3);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, request, this.endpoint, context);
        ClassicHttpResponse finalResponse = this.redirectExec.execute(request, scope, this.chain);
        Assertions.assertEquals((int)200, (int)finalResponse.getCode());
        ArgumentCaptor reqCaptor = ArgumentCaptor.forClass(ClassicHttpRequest.class);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)3))).proceed((ClassicHttpRequest)reqCaptor.capture(), (ExecChain.Scope)ArgumentMatchers.same((Object)scope));
        List allValues = reqCaptor.getAllValues();
        Assertions.assertNotNull((Object)allValues);
        Assertions.assertEquals((int)3, (int)allValues.size());
        ClassicHttpRequest request1 = (ClassicHttpRequest)allValues.get(0);
        ClassicHttpRequest request2 = (ClassicHttpRequest)allValues.get(1);
        ClassicHttpRequest request3 = (ClassicHttpRequest)allValues.get(2);
        Assertions.assertSame((Object)request, (Object)request1);
        Assertions.assertEquals((Object)request1.getMethod(), (Object)"PUT");
        Assertions.assertEquals((Object)request2.getMethod(), (Object)"GET");
        Assertions.assertEquals((Object)request3.getMethod(), (Object)"GET");
    }

    private static class HttpRequestMatcher
    implements ArgumentMatcher<ClassicHttpRequest> {
        private final URI expectedRequestUri;

        HttpRequestMatcher(URI requestUri) {
            this.expectedRequestUri = requestUri;
        }

        public boolean matches(ClassicHttpRequest argument) {
            if (argument == null) {
                return false;
            }
            try {
                URI requestUri = argument.getUri();
                return this.expectedRequestUri.equals(requestUri);
            }
            catch (URISyntaxException ex) {
                return false;
            }
        }

        static ClassicHttpRequest matchesRequestUri(URI requestUri) {
            return (ClassicHttpRequest)ArgumentMatchers.argThat((ArgumentMatcher)new HttpRequestMatcher(requestUri));
        }
    }
}

