/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.MainClientExec;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.TimeValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestMainClientExec {
    @Mock
    private HttpClientConnectionManager connectionManager;
    @Mock
    private HttpProcessor httpProcessor;
    @Mock
    private ConnectionReuseStrategy reuseStrategy;
    @Mock
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    @Mock
    private UserTokenHandler userTokenHandler;
    @Mock
    private ExecRuntime execRuntime;
    private MainClientExec mainClientExec;
    private HttpHost target;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        this.mainClientExec = new MainClientExec(this.connectionManager, this.httpProcessor, this.reuseStrategy, this.keepAliveStrategy, this.userTokenHandler);
        this.target = new HttpHost("foo", 80);
    }

    @Test
    public void testFundamentals() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity responseEntity = EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build();
        response.setEntity(responseEntity);
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((HttpProcessor)Mockito.verify((Object)this.httpProcessor)).process((HttpRequest)request, null, (HttpContext)context);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).execute((String)Mockito.eq((Object)"test"), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any());
        ((HttpProcessor)Mockito.verify((Object)this.httpProcessor)).process((HttpResponse)response, (EntityDetails)responseEntity, (HttpContext)context);
        Assertions.assertEquals((Object)route, (Object)context.getHttpRoute());
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertSame((Object)response, (Object)context.getResponse());
    }

    @Test
    public void testExecRequestNonPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)false);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).execute((String)Mockito.eq((Object)"test"), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any());
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.times((int)1))).markConnectionNonReusable();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.never())).releaseEndpoint();
        Assertions.assertNull((Object)context.getUserToken());
        Assertions.assertNotNull((Object)finalResponse);
        Assertions.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestNonPersistentConnectionNoResponseEntity() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(null);
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)false);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).execute((String)Mockito.eq((Object)"test"), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any());
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).markConnectionNonReusable();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).releaseEndpoint();
        Assertions.assertNotNull((Object)finalResponse);
        Assertions.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)TimeValue.ofMilliseconds((long)678L));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).execute((String)Mockito.eq((Object)"test"), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any());
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).markConnectionReusable(null, TimeValue.ofMilliseconds((long)678L));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.never())).releaseEndpoint();
        Assertions.assertNotNull((Object)finalResponse);
        Assertions.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestPersistentConnectionNoResponseEntity() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)TimeValue.ofMilliseconds((long)678L));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).execute((String)Mockito.eq((Object)"test"), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any());
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).releaseEndpoint();
        Assertions.assertNotNull((Object)finalResponse);
        Assertions.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
    }

    @Test
    public void testExecRequestConnectionRelease() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.mainClientExec.execute((ClassicHttpRequest)request, scope, null);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.times((int)1))).execute((String)Mockito.eq((Object)"test"), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any());
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.never())).disconnectEndpoint();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.never())).releaseEndpoint();
        Assertions.assertNotNull((Object)finalResponse);
        Assertions.assertTrue((boolean)(finalResponse instanceof CloseableHttpResponse));
        finalResponse.close();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).disconnectEndpoint();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    public void testExecConnectionShutDown() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectionShutdownException()});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(InterruptedIOException.class, () -> this.lambda$testExecConnectionShutDown$0((ClassicHttpRequest)request, scope));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    public void testExecRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Ka-boom")});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(RuntimeException.class, () -> this.lambda$testExecRuntimeException$1((ClassicHttpRequest)request, scope));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    public void testExecHttpException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new HttpException("Ka-boom")});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(HttpException.class, () -> this.lambda$testExecHttpException$2((ClassicHttpRequest)request, scope));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    public void testExecIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = HttpClientContext.create();
        HttpGet request = new HttpGet("http://bar/test");
        Mockito.when((Object)this.execRuntime.execute(Mockito.anyString(), (ClassicHttpRequest)Mockito.same((Object)request), (HttpResponseInformationCallback)Mockito.any(), (HttpClientContext)Mockito.any())).thenThrow(new Throwable[]{new IOException("Ka-boom")});
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        Assertions.assertThrows(IOException.class, () -> this.lambda$testExecIOException$3((ClassicHttpRequest)request, scope));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    private /* synthetic */ void lambda$testExecIOException$3(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.mainClientExec.execute(request, scope, null);
    }

    private /* synthetic */ void lambda$testExecHttpException$2(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.mainClientExec.execute(request, scope, null);
    }

    private /* synthetic */ void lambda$testExecRuntimeException$1(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.mainClientExec.execute(request, scope, null);
    }

    private /* synthetic */ void lambda$testExecConnectionShutDown$0(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.mainClientExec.execute(request, scope, null);
    }
}

