/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.time.Instant;
import java.util.Map;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.classic.LinearBackoffManager;
import org.apache.hc.client5.http.impl.classic.MockConnPoolControl;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.TimeValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLinearBackoffManager {
    private LinearBackoffManager impl;
    private MockConnPoolControl connPerRoute;
    private HttpRoute route;
    private static final long DEFAULT_COOL_DOWN_MS = 10L;

    @BeforeEach
    public void setUp() {
        this.connPerRoute = new MockConnPoolControl();
        this.route = new HttpRoute(new HttpHost("localhost", 80));
        this.impl = new LinearBackoffManager((ConnPoolControl)this.connPerRoute);
        this.impl.setCoolDown(TimeValue.ofMilliseconds((long)10L));
    }

    @Test
    public void incrementsConnectionsOnBackoff() {
        LinearBackoffManager impl = new LinearBackoffManager((ConnPoolControl)this.connPerRoute);
        impl.setCoolDown(TimeValue.ofMilliseconds((long)10L));
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        impl.backOff(this.route);
        Assertions.assertEquals((int)5, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void decrementsConnectionsOnProbe() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.probe(this.route);
        Assertions.assertEquals((int)3, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void backoffDoesNotAdjustDuringCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.backOff(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(9L));
        this.impl.backOff(this.route);
        Assertions.assertEquals((long)max, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void backoffStillAdjustsAfterCoolDownPeriod() {
        LinearBackoffManager impl = new LinearBackoffManager((ConnPoolControl)this.connPerRoute);
        impl.setCoolDown(TimeValue.ofMilliseconds((long)10L));
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        impl.backOff(this.route);
        int max1 = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteBackoffs = impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(11L));
        impl.backOff(this.route);
        int max2 = this.connPerRoute.getMaxPerRoute(this.route);
        Assertions.assertTrue((max2 > max1 ? 1 : 0) != 0);
    }

    @Test
    public void probeDoesNotAdjustDuringCooldownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now());
        this.impl.probe(this.route);
        Assertions.assertEquals((long)max, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void probeStillAdjustsAfterCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.probe(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(11L));
        this.impl.probe(this.route);
        long newMax = this.connPerRoute.getMaxPerRoute(this.route);
        Assertions.assertEquals((long)2L, (long)newMax);
    }

    @Test
    public void testSetPerHostConnectionCap() {
        this.connPerRoute.setMaxPerRoute(this.route, 5);
        this.impl.setPerHostConnectionCap(10);
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)6, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    public void probeUpdatesRemainingAttemptsIndirectly() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.backOff(this.route);
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(11L));
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)6, (int)this.connPerRoute.getMaxPerRoute(this.route));
        this.impl.probe(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(20L));
        this.impl.probe(this.route);
        Assertions.assertEquals((int)5, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    public void linearIncrementTest() {
        int initialMax = 4;
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        for (int i = 1; i <= 5; ++i) {
            lastRouteBackoffs.put(this.route, Instant.now().minusMillis(11L));
            this.impl.backOff(this.route);
            Assertions.assertEquals((int)(4 + i), (int)this.connPerRoute.getMaxPerRoute(this.route));
        }
    }
}

