/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.io.CloseMode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHttpClientBuilderInterceptors {
    private HttpServer localServer;
    private String uri;
    private CloseableHttpClient httpClient;

    @BeforeEach
    public void before() throws Exception {
        this.localServer = ServerBootstrap.bootstrap().register("/test", (request, response, context) -> {
            Header testInterceptorHeader = request.getHeader("X-Test-Interceptor");
            if (testInterceptorHeader != null) {
                response.setHeader(testInterceptorHeader);
            }
            response.setCode(200);
        }).create();
        this.localServer.start();
        this.uri = "http://localhost:" + this.localServer.getLocalPort() + "/test";
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(5).build();
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).addExecInterceptorLast("test-interceptor", (request, scope, chain) -> {
            request.setHeader("X-Test-Interceptor", (Object)"active");
            return chain.proceed(request, scope);
        }).build();
    }

    @AfterEach
    public void after() throws Exception {
        this.httpClient.close(CloseMode.IMMEDIATE);
        this.localServer.stop();
    }

    @Test
    public void testAddExecInterceptorLastShouldBeExecuted() throws IOException, HttpException {
        HttpPost request = new HttpPost(this.uri);
        HttpResponse response = (HttpResponse)this.httpClient.execute((ClassicHttpRequest)request, httpResponse -> {
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            return httpResponse;
        });
        Assertions.assertEquals((int)200, (int)response.getCode());
        Header testFilterHeader = response.getHeader("X-Test-Interceptor");
        Assertions.assertNotNull((Object)testFilterHeader);
    }
}

