/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.FutureRequestExecutionService;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFutureRequestExecutionService {
    private HttpServer localServer;
    private String uri;
    private FutureRequestExecutionService httpAsyncClientWithFuture;
    private final AtomicBoolean blocked = new AtomicBoolean(false);

    @BeforeEach
    public void before() throws Exception {
        this.localServer = ServerBootstrap.bootstrap().register("/wait", (request, response, context) -> {
            try {
                while (this.blocked.get()) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            response.setCode(200);
        }).create();
        this.localServer.start();
        this.uri = "http://localhost:" + this.localServer.getLocalPort() + "/wait";
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(5).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).build();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        this.httpAsyncClientWithFuture = new FutureRequestExecutionService((HttpClient)httpClient, executorService);
    }

    @AfterEach
    public void after() throws Exception {
        this.blocked.set(false);
        this.localServer.stop();
        this.httpAsyncClientWithFuture.close();
    }

    @Test
    public void shouldExecuteSingleCall() throws InterruptedException, ExecutionException {
        FutureTask task = this.httpAsyncClientWithFuture.execute((ClassicHttpRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (HttpClientResponseHandler)new OkidokiHandler());
        Assertions.assertTrue((boolean)((Boolean)task.get()), (String)"request should have returned OK");
    }

    @Test
    public void shouldCancel() throws InterruptedException, ExecutionException {
        FutureTask task = this.httpAsyncClientWithFuture.execute((ClassicHttpRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (HttpClientResponseHandler)new OkidokiHandler());
        task.cancel(true);
        Exception exception = (Exception)Assertions.assertThrows(Exception.class, task::get);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(CancellationException.class), CoreMatchers.instanceOf(ExecutionException.class)}));
    }

    @Test
    public void shouldTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        this.blocked.set(true);
        FutureTask task = this.httpAsyncClientWithFuture.execute((ClassicHttpRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (HttpClientResponseHandler)new OkidokiHandler());
        Assertions.assertThrows(TimeoutException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)task.get(10L, TimeUnit.MILLISECONDS);
        });
    }

    @Test
    public void shouldExecuteMultipleCalls() throws Exception {
        int reqNo = 100;
        LinkedList<Future> tasks = new LinkedList<Future>();
        for (int i = 0; i < 100; ++i) {
            Future task = this.httpAsyncClientWithFuture.execute((ClassicHttpRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (HttpClientResponseHandler)new OkidokiHandler());
            tasks.add(task);
        }
        for (Future task : tasks) {
            Boolean b = (Boolean)task.get();
            Assertions.assertNotNull((Object)b);
            Assertions.assertTrue((boolean)b, (String)"request should have returned OK");
        }
    }

    @Test
    public void shouldExecuteMultipleCallsAndCallback() throws Exception {
        int reqNo = 100;
        LinkedList<Future> tasks = new LinkedList<Future>();
        CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            Future task = this.httpAsyncClientWithFuture.execute((ClassicHttpRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (HttpClientResponseHandler)new OkidokiHandler(), (FutureCallback)new CountingCallback(latch));
            tasks.add(task);
        }
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        for (Future task : tasks) {
            Boolean b = (Boolean)task.get();
            Assertions.assertNotNull((Object)b);
            Assertions.assertTrue((boolean)b, (String)"request should have returned OK");
        }
    }

    private final class OkidokiHandler
    implements HttpClientResponseHandler<Boolean> {
        private OkidokiHandler() {
        }

        public Boolean handleResponse(ClassicHttpResponse response) throws IOException {
            return response.getCode() == 200;
        }
    }

    private final class CountingCallback
    implements FutureCallback<Boolean> {
        private final CountDownLatch latch;

        CountingCallback(CountDownLatch latch) {
            this.latch = latch;
        }

        public void failed(Exception ex) {
            this.latch.countDown();
        }

        public void completed(Boolean result) {
            this.latch.countDown();
        }

        public void cancelled() {
            this.latch.countDown();
        }
    }
}

