/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.hc.client5.http.impl.classic.DefaultBackoffStrategy;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDefaultBackoffStrategy {
    private DefaultBackoffStrategy impl;

    @BeforeEach
    public void setUp() {
        this.impl = new DefaultBackoffStrategy();
    }

    @Test
    public void backsOffForSocketTimeouts() {
        Assertions.assertTrue((boolean)this.impl.shouldBackoff((Throwable)new SocketTimeoutException()));
    }

    @Test
    public void backsOffForConnectionTimeouts() {
        Assertions.assertTrue((boolean)this.impl.shouldBackoff((Throwable)new ConnectException()));
    }

    @Test
    public void doesNotBackOffForConnectionManagerTimeout() {
        Assertions.assertFalse((boolean)this.impl.shouldBackoff((Throwable)new ConnectionRequestTimeoutException()));
    }

    @Test
    public void backsOffForServiceUnavailable() {
        BasicHttpResponse resp = new BasicHttpResponse(503, "Service Unavailable");
        Assertions.assertTrue((boolean)this.impl.shouldBackoff((HttpResponse)resp));
    }

    @Test
    public void backsOffForTooManyRequests() {
        BasicHttpResponse resp = new BasicHttpResponse(429, "Too Many Requests");
        Assertions.assertTrue((boolean)this.impl.shouldBackoff((HttpResponse)resp));
    }

    @Test
    public void doesNotBackOffForNon429And503StatusCodes() {
        for (int i = 100; i <= 599; ++i) {
            if (i == 429 || i == 503) continue;
            BasicHttpResponse resp = new BasicHttpResponse(i, "Foo");
            Assertions.assertFalse((boolean)this.impl.shouldBackoff((HttpResponse)resp));
        }
    }
}

