/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieIdentityComparator;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCookieIdentityComparator {
    @Test
    public void testCookieIdentityComparasionByName() {
        CookieIdentityComparator comparator = CookieIdentityComparator.INSTANCE;
        BasicClientCookie c1 = new BasicClientCookie("name", "value1");
        BasicClientCookie c2 = new BasicClientCookie("name", "value2");
        Assertions.assertEquals((int)0, (int)comparator.compare((Cookie)c1, (Cookie)c2));
        BasicClientCookie c3 = new BasicClientCookie("name1", "value");
        BasicClientCookie c4 = new BasicClientCookie("name2", "value");
        Assertions.assertNotEquals((int)0, (int)comparator.compare((Cookie)c3, (Cookie)c4));
    }

    @Test
    public void testCookieIdentityComparasionByNameAndDomain() {
        CookieIdentityComparator comparator = CookieIdentityComparator.INSTANCE;
        BasicClientCookie c1 = new BasicClientCookie("name", "value1");
        c1.setDomain("www.domain.com");
        BasicClientCookie c2 = new BasicClientCookie("name", "value2");
        c2.setDomain("www.domain.com");
        Assertions.assertEquals((int)0, (int)comparator.compare((Cookie)c1, (Cookie)c2));
        BasicClientCookie c3 = new BasicClientCookie("name", "value1");
        c3.setDomain("www.domain.com");
        BasicClientCookie c4 = new BasicClientCookie("name", "value2");
        c4.setDomain("domain.com");
        Assertions.assertNotEquals((int)0, (int)comparator.compare((Cookie)c3, (Cookie)c4));
    }

    @Test
    public void testCookieIdentityComparasionByNameAndNullDomain() {
        CookieIdentityComparator comparator = CookieIdentityComparator.INSTANCE;
        BasicClientCookie c1 = new BasicClientCookie("name", "value1");
        c1.setDomain(null);
        BasicClientCookie c2 = new BasicClientCookie("name", "value2");
        c2.setDomain(null);
        Assertions.assertEquals((int)0, (int)comparator.compare((Cookie)c1, (Cookie)c2));
        BasicClientCookie c3 = new BasicClientCookie("name", "value1");
        c3.setDomain("www.domain.com");
        BasicClientCookie c4 = new BasicClientCookie("name", "value2");
        c4.setDomain(null);
        Assertions.assertNotEquals((int)0, (int)comparator.compare((Cookie)c3, (Cookie)c4));
    }

    @Test
    public void testCookieIdentityComparasionByNameDomainAndPath() {
        CookieIdentityComparator comparator = CookieIdentityComparator.INSTANCE;
        BasicClientCookie c1 = new BasicClientCookie("name", "value1");
        c1.setDomain("www.domain.com");
        c1.setPath("/whatever");
        BasicClientCookie c2 = new BasicClientCookie("name", "value2");
        c2.setDomain("www.domain.com");
        c2.setPath("/whatever");
        Assertions.assertEquals((int)0, (int)comparator.compare((Cookie)c1, (Cookie)c2));
        BasicClientCookie c3 = new BasicClientCookie("name", "value1");
        c3.setDomain("www.domain.com");
        c3.setPath("/whatever");
        BasicClientCookie c4 = new BasicClientCookie("name", "value2");
        c4.setDomain("domain.com");
        c4.setPath("/whatever-not");
        Assertions.assertNotEquals((int)0, (int)comparator.compare((Cookie)c3, (Cookie)c4));
    }

    @Test
    public void testCookieIdentityComparasionByNameDomainAndNullPath() {
        CookieIdentityComparator comparator = CookieIdentityComparator.INSTANCE;
        BasicClientCookie c1 = new BasicClientCookie("name", "value1");
        c1.setDomain("www.domain.com");
        c1.setPath("/");
        BasicClientCookie c2 = new BasicClientCookie("name", "value2");
        c2.setDomain("www.domain.com");
        c2.setPath(null);
        Assertions.assertEquals((int)0, (int)comparator.compare((Cookie)c1, (Cookie)c2));
        BasicClientCookie c3 = new BasicClientCookie("name", "value1");
        c3.setDomain("www.domain.com");
        c3.setPath("/whatever");
        BasicClientCookie c4 = new BasicClientCookie("name", "value2");
        c4.setDomain("domain.com");
        c4.setPath(null);
        Assertions.assertNotEquals((int)0, (int)comparator.compare((Cookie)c3, (Cookie)c4));
    }
}

