/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.DecompressingEntity;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.entity.GzipDecompressingEntity;
import org.apache.hc.client5.http.impl.classic.ContentCompressionExec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestContentCompressionExec {
    @Mock
    private ExecRuntime execRuntime;
    @Mock
    private ExecChain execChain;
    @Mock
    private ClassicHttpRequest originaRequest;
    private HttpClientContext context;
    private HttpHost host;
    private ExecChain.Scope scope;
    private ContentCompressionExec impl;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.openMocks((Object)this);
        this.host = new HttpHost("somehost", 80);
        this.context = HttpClientContext.create();
        this.scope = new ExecChain.Scope("test", new HttpRoute(this.host), this.originaRequest, this.execRuntime, this.context);
        this.impl = new ContentCompressionExec();
    }

    @Test
    public void testContentEncodingNoEntity() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNull((Object)entity);
    }

    @Test
    public void testNoContentEncoding() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        StringEntity original = new StringEntity("plain stuff");
        response.setEntity((HttpEntity)original);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity instanceof StringEntity));
    }

    @Test
    public void testGzipContentEncoding() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("encoded stuff").setContentEncoding("GZip").build();
        response.setEntity(original);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity instanceof DecompressingEntity));
    }

    @Test
    public void testGzipContentEncodingZeroLength() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("").setContentEncoding("GZip").build();
        response.setEntity(original);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity instanceof StringEntity));
    }

    @Test
    public void testXGzipContentEncoding() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("encoded stuff").setContentEncoding("x-gzip").build();
        response.setEntity(original);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity instanceof DecompressingEntity));
    }

    @Test
    public void testDeflateContentEncoding() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("encoded stuff").setContentEncoding("deFlaTe").build();
        response.setEntity(original);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity instanceof DecompressingEntity));
    }

    @Test
    public void testIdentityContentEncoding() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("encoded stuff").setContentEncoding("identity").build();
        response.setEntity(original);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity instanceof StringEntity));
    }

    @Test
    public void testBrotliContentEncoding() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("encoded stuff").setContentEncoding("br").build();
        response.setEntity(original);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity instanceof DecompressingEntity));
    }

    @Test
    public void testUnknownContentEncoding() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("encoded stuff").setContentEncoding("whatever").build();
        response.setEntity(original);
        this.impl = new ContentCompressionExec(false);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        Assertions.assertThrows(HttpException.class, () -> this.lambda$testUnknownContentEncoding$0((ClassicHttpRequest)request));
    }

    @Test
    public void testContentEncodingRequestParameter() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, this.host, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpEntity original = EntityBuilder.create().setText("encoded stuff").setContentEncoding("GZip").build();
        response.setEntity(original);
        RequestConfig config = RequestConfig.custom().setContentCompressionEnabled(false).build();
        this.context.setRequestConfig(config);
        Mockito.when((Object)this.execChain.proceed((ClassicHttpRequest)request, this.scope)).thenReturn((Object)response);
        this.impl.execute((ClassicHttpRequest)request, this.scope, this.execChain);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertFalse((boolean)(entity instanceof GzipDecompressingEntity));
    }

    private /* synthetic */ void lambda$testUnknownContentEncoding$0(ClassicHttpRequest request) throws Throwable {
        this.impl.execute(request, this.scope, this.execChain);
    }
}

