/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Locale;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestSystemDefaultCredentialsProvider {
    private static final String PROXY_PROTOCOL1 = "http";
    private static final String PROXY_HOST1 = "proxyhost1";
    private static final int PROXY_PORT1 = 3128;
    private static final String PROMPT1 = "HttpClient authentication test prompt";
    private static final String TARGET_SCHEME1 = "https";
    private static final String TARGET_HOST1 = "targethost1";
    private static final int TARGET_PORT1 = 80;
    private static final PasswordAuthentication AUTH1 = new PasswordAuthentication("testUser", "testPassword".toCharArray());

    @Test
    public void testSystemCredentialsProviderCredentials() throws Exception {
        AuthenticatorDelegate authenticatorDelegate = this.installAuthenticator(AUTH1);
        URL httpRequestUrl = new URL(TARGET_SCHEME1, TARGET_HOST1, 80, "/");
        AuthScope authScope = new AuthScope(PROXY_PROTOCOL1, PROXY_HOST1, 3128, PROMPT1, "Basic");
        HttpClientContext context = HttpClientContext.create();
        context.setRequest((HttpRequest)new HttpGet(httpRequestUrl.toURI()));
        Credentials receivedCredentials = new SystemDefaultCredentialsProvider().getCredentials(authScope, (HttpContext)context);
        ((AuthenticatorDelegate)Mockito.verify((Object)authenticatorDelegate)).getPasswordAuthentication(PROXY_HOST1, null, 3128, PROXY_PROTOCOL1, PROMPT1, "Basic".toUpperCase(Locale.ROOT), httpRequestUrl, Authenticator.RequestorType.SERVER);
        Assertions.assertNotNull((Object)receivedCredentials);
        Assertions.assertEquals((Object)AUTH1.getUserName(), (Object)receivedCredentials.getUserPrincipal().getName());
    }

    @Test
    public void testSystemCredentialsProviderNoContext() throws Exception {
        AuthenticatorDelegate authenticatorDelegate = this.installAuthenticator(AUTH1);
        AuthScope authScope = new AuthScope(PROXY_PROTOCOL1, PROXY_HOST1, 3128, PROMPT1, "Basic");
        Credentials receivedCredentials = new SystemDefaultCredentialsProvider().getCredentials(authScope, null);
        ((AuthenticatorDelegate)Mockito.verify((Object)authenticatorDelegate)).getPasswordAuthentication(PROXY_HOST1, null, 3128, PROXY_PROTOCOL1, PROMPT1, "Basic".toUpperCase(Locale.ROOT), null, Authenticator.RequestorType.SERVER);
        Assertions.assertNotNull((Object)receivedCredentials);
        Assertions.assertEquals((Object)AUTH1.getUserName(), (Object)receivedCredentials.getUserPrincipal().getName());
    }

    private AuthenticatorDelegate installAuthenticator(PasswordAuthentication returedAuthentication) {
        AuthenticatorDelegate authenticatorDelegate = (AuthenticatorDelegate)Mockito.mock(AuthenticatorDelegate.class);
        Mockito.when((Object)authenticatorDelegate.getPasswordAuthentication(ArgumentMatchers.anyString(), (InetAddress)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (URL)ArgumentMatchers.any(), (Authenticator.RequestorType)((Object)ArgumentMatchers.any()))).thenReturn((Object)returedAuthentication);
        Authenticator.setDefault(new DelegatedAuthenticator(authenticatorDelegate));
        return authenticatorDelegate;
    }

    private static interface AuthenticatorDelegate {
        public PasswordAuthentication getPasswordAuthentication(String var1, InetAddress var2, int var3, String var4, String var5, String var6, URL var7, Authenticator.RequestorType var8);
    }

    private static final class DelegatedAuthenticator
    extends Authenticator {
        private final AuthenticatorDelegate authenticatorDelegate;

        private DelegatedAuthenticator(AuthenticatorDelegate authenticatorDelegate) {
            this.authenticatorDelegate = authenticatorDelegate;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authenticatorDelegate.getPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme(), this.getRequestingURL(), this.getRequestorType());
        }
    }
}

